//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCX񋓃wb_
 * @author Junpee
 */

#ifndef GRAPHICS_DEVICE_ENUMERATION_H_
#define GRAPHICS_DEVICE_ENUMERATION_H_

#include <Core/Container/ArrayList.h>
#include <Graphics/Enumeration/ConfirmGraphicsDevice.h>
#include <Graphics/Enumeration/GraphicsDeviceComboInformation.h>
#include <Graphics/Enumeration/GraphicsDeviceInformation.h>
#include <Graphics/Enumeration/GraphicsAdapterInformation.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * OtBbNXfoCX
 */
class GraphicsDeviceEnumeration : public ConfirmGraphicsDevice{
friend class LampGraphics;
public:
	//--------------------------------------------------------------------------
	/**
	 * CX^X擾
	 * @return CX^X
	 */
	static GraphicsDeviceEnumeration* getInstance(){
		Assert(instance_ != NULL);
		return instance_;
	}

	//--------------------------------------------------------------------------
	// 񋓗pp[^
	//--------------------------------------------------------------------------
	/**
	 * tH[}bg̒ǉ
	 * @param allowedFormat tH[}bg
	 */
	virtual void addAllowedFormat(D3DFORMAT allowedFormat){
		allowedFormats_.add(allowedFormat);
	}

	/**
	 * tH[}bg̍폜
	 * @param allowedFormat tH[}bg
	 */
	virtual void removeAllowedFormat(D3DFORMAT allowedFormat){
		allowedFormats_.removeByValue(allowedFormat);
	}

	/**
	 * tH[}bg̎擾
	 * @return tH[}bg
	 */
	virtual int getAllowedFormatCount() const{
		return allowedFormats_.getCount();
	}

	/**
	 * tH[}bg̎擾
	 * @return tH[}bg
	 */
	virtual D3DFORMAT getAllowedFormat(int index){
		return allowedFormats_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * OtBbNXfoCXmFC^[tF[X̐ݒ
	 * @param confirm OtBbNXfoCXmFC^[tF[X
	 */
	virtual void setConfirmGraphicsDevice(ConfirmGraphicsDevice* confirm){
		Assert(confirm != NULL);
		confirmGraphicsDevice_ = confirm;
	}

	/**
	 * OtBbNXfoCXmFC^[tF[X̎擾
	 * @return OtBbNXfoCXmFC^[tF[X
	 */
	virtual ConfirmGraphicsDevice* getConfirmGraphicsDevice() const{
		return confirmGraphicsDevice_;
	}

	/**
	 * OtBbNXfoCX̊mF
	 * @param deviceCapability foCX\
	 * @param vertexProcessingType _vZX^Cv
	 * @param adapterFormat A_v^̃tH[}bg
	 * @param backBufferFormat obNobt@̃tH[}bg
	 * @return foCX̎gpȂtrueԂB
	 */
	virtual bool confirmGraphicsDevice(
		const D3DCapacity& deviceCapability, u_int vertexProcessingType,
		D3DFORMAT adapterFormat, D3DFORMAT backBufferFormat){ return true; }

	//--------------------------------------------------------------------------
	/**
	 * ŏtXN[̐ݒ
	 * @param width ŏtXN[
	 */
	virtual void setMinimumFullscreenWidth(u_int width){
		minimumFullscreenWidth_ = width;
	}

	/**
	 * ŏtXN[̎擾
	 * @return ŏtXN[
	 */
	virtual u_int getMinimumFullscreenWidth() const{
		return minimumFullscreenWidth_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ŏtXN[̐ݒ
	 * @param height ŏtXN[
	 */
	virtual void setMinimumFullscreenHeight(u_int height){
		minimumFullscreenHeight_ = height;
	}

	/**
	 * ŏtXN[̎擾
	 * @return ŏtXN[
	 */
	virtual u_int getMinimumFullscreenHeight() const{
		return minimumFullscreenHeight_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ŏA_v^J[`lrbg̐ݒ
	 * @param bits ŏA_v^J[`lrbg
	 */
	virtual void setMinimumAdapterColorChannelBits(u_int bits){
		minimumAdapterColorChannelBits_ = bits;
	}

	/**
	 * ŏA_v^J[`lrbg̎擾
	 * @return ŏA_v^J[`lrbg
	 */
	virtual u_int getMinimumAdapterColorChannelBits() const{
		return minimumAdapterColorChannelBits_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ŏobNobt@At@`lrbg̐ݒ
	 * @param bits ŏobNobt@At@`lrbg
	 */
	virtual void setMinimumBackBufferAlphaChannelBits(u_int bits){
		minimumBackBufferAlphaChannelBits_ = bits;
	}

	/**
	 * ŏobNobt@At@`lrbg̎擾
	 * @return ŏobNobt@At@`lrbg
	 */
	virtual u_int getMinimumBackBufferAlphaChannelBits() const{
		return minimumBackBufferAlphaChannelBits_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ŏ[xrbg̐ݒ
	 * @param bits ŏ[xrbg
	 */
	virtual void setMinimumDepthBits(u_int bits){
		minimumDepthBits_ = bits;
	}

	/**
	 * ŏ[xrbg̎擾
	 * @return ŏ[xrbg
	 */
	virtual u_int getMinimumDepthBits() const{
		return minimumDepthBits_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ŏXeVrbg̐ݒ
	 * @param bits ŏXeVrbg
	 */
	virtual void setMinimumStencilBits(u_int bits){
		minimumStencilBits_ = bits;
	}

	/**
	 * ŏXeVrbg̎擾
	 * @return ŏXeVrbg
	 */
	virtual u_int getMinimumStencilBits() const{
		return minimumStencilBits_;
	}

	//--------------------------------------------------------------------------
	/**
	 * EBhE[hKvǂ̐ݒ
	 * @param requires EBhE[hKvȂtrue
	 */
	virtual void setRequiresWindowMode(bool requires){
		requiresWindowMode_ = requires;
	}

	/**
	 * EBhE[hKvǂ̎擾
	 * @return EBhE[hKvȂtrue
	 */
	virtual bool getRequiresWindowMode() const{
		return requiresWindowMode_;
	}

	//--------------------------------------------------------------------------
	/**
	 * tXN[[hKvǂ̐ݒ
	 * @param requires tXN[[hKvȂtrue
	 */
	virtual void setRequiresFullscreenMode(bool requires){
		requiresFullscreenMode_ = requires;
	}

	/**
	 * tXN[[hKvǂ̎擾
	 * @return tXN[[hKvȂtrue
	 */
	virtual bool getRequiresFullscreenMode() const{
		return requiresFullscreenMode_;
	}

	//--------------------------------------------------------------------------
	/**
	 * [xAXeVobt@gp邩̐ݒ
	 * @param uses [xAXeVobt@gpȂtrue
	 */
	virtual void setUsesDepthStencilBuffer(bool uses){
		usesDepthStencilBuffer_ = uses;
	}

	/**
	 * [xAXeVobt@gp邩̎擾
	 * @return [xAXeVobt@gpȂtrue
	 */
	virtual bool getUsesDepthStencilBuffer() const{
		return usesDepthStencilBuffer_;
	}

	//--------------------------------------------------------------------------
	/**
	 * _Zgp邩̐ݒ
	 * @param uses _ZgpȂtrue
	 */
	virtual void setUsesMixedVertexProcessing(bool uses){
		usesMixedVertexProcessing_ = uses;
	}

	/**
	 * _Zgp邩̎擾
	 * @return _ZgpȂtrue
	 */
	virtual bool getUsesMixedVertexProcessing() const{
		return usesMixedVertexProcessing_;
	}

	//--------------------------------------------------------------------------
	// 񋓂̌ʎ擾
	//--------------------------------------------------------------------------
	/**
	 * A_v^̎擾
	 * @return A_v^
	 */
	virtual int getAdapterCount(){ return adapters_.getCount(); }

	/**
	 * A_v^̎擾
	 * @param index A_v^̃CfNX
	 * @return A_v^
	 */
	virtual GraphicsAdapterInformation* getAdapter(int index){
		return adapters_.get(index);
	}

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 */
	GraphicsDeviceEnumeration();

	/**
	 * fXgN^
	 */
	virtual ~GraphicsDeviceEnumeration();

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return gpłfoCX݂true
	 */
	virtual bool enumerate();

private:
	// Rs[RXgN^̉B
	GraphicsDeviceEnumeration(const GraphicsDeviceEnumeration& copy);

	// Rs[̉B
	void operator =(const GraphicsDeviceEnumeration& copy);

	//--------------------------------------------------------------------------
	// 񋓗pp[^
	//--------------------------------------------------------------------------
	// tH[}bg
	ArrayList<D3DFORMAT> allowedFormats_;
	// OtBbNXfoCXmF
	ConfirmGraphicsDevice* confirmGraphicsDevice_;
	// ŏtXN[
	u_int minimumFullscreenWidth_;
	// ŏtXN[
	u_int minimumFullscreenHeight_;
	// ŏA_v^J[`lrbg
	u_int minimumAdapterColorChannelBits_;
	// ŏobNobt@At@`lrbg
	u_int minimumBackBufferAlphaChannelBits_;
	// ŏ[xrbg
	u_int minimumDepthBits_;
	// ŏXeVrbg
	u_int minimumStencilBits_;
	// EBhE[hKv
	bool requiresWindowMode_;
	// tXN[[hKv
	bool requiresFullscreenMode_;
	// [xAXeVobt@gp邩
	bool usesDepthStencilBuffer_;
	// _Zgp邩
	bool usesMixedVertexProcessing_;

	// A_v^
	ArrayList<GraphicsAdapterInformation*> adapters_;
	// 񋓍ς݂ǂ
	bool enumerated_;

	// CX^X
	static GraphicsDeviceEnumeration* instance_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_DEVICE_ENUMERATION_H_
//------------------------------------------------------------------------------

