//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCXR{wb_
 * @author Junpee
 */

#ifndef GRAPHICS_DEVICE_COMBO_INFORMATION_H_
#define GRAPHICS_DEVICE_COMBO_INFORMATION_H_

#include <Core/Container/ArrayList.h>
#include <Graphics/Primitive/VertexProcessingType.h>

namespace Lamp{

class GraphicsDeviceEnumeration;
class GraphicsDeviceInformation;
class ConfirmGraphicsDevice;

//------------------------------------------------------------------------------
/**
 * OtBbNXfoCXR{
 */
class GraphicsDeviceComboInformation{
friend class GraphicsDeviceInformation;
public:
	//--------------------------------------------------------------------------
	/**
	 * A_v^tH[}bg̎擾
	 * @return A_v^tH[}bg
	 */
	virtual D3DFORMAT getAdapterFormat(){ return adapterFormat_; }

	/**
	 * obNobt@tH[}bg̎擾
	 * @return obNobt@tH[}bg
	 */
	virtual D3DFORMAT getBackBufferFormat(){ return backBufferFormat_; }

	/**
	 * EBhEtO̎擾
	 * @return EBhEtO
	 */
	virtual bool isWindowed(){ return isWindowed_; }

	//--------------------------------------------------------------------------
	/**
	 * A_v^ԍ̎擾
	 * @return A_v^ԍ
	 */
	virtual int getAdapterOrdinal(){ return adapterOrdinal_; }

	/**
	 * foCX^Cv̎擾
	 * @return foCX^Cv
	 */
	virtual D3DDEVTYPE getDeviceType(){ return deviceType_; }

	//--------------------------------------------------------------------------
	/**
	 * [xAXeVtH[}bg̎擾
	 * @return [xAXeVtH[}bg
	 */
	virtual int getDepthStencilFormatCount() const{
		return depthStencilFormats_.getCount();
	}

	/**
	 * [xAXeVtH[}bg̎擾
	 * @param index CfbNX
	 * @return [xAXeVtH[}bg
	 */
	virtual D3DFORMAT getDepthStencilFormat(int index){
		return depthStencilFormats_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * }`Tv^Cv̎擾
	 * @return }`Tv^Cv
	 */
	virtual int getMultiSampleTypeCount() const{
		return multiSampleTypes_.getCount();
	}

	/**
	 * }`Tv^Cv̎擾
	 * @param index CfbNX
	 * @return }`Tv^Cv
	 */
	virtual D3DMULTISAMPLE_TYPE getMultiSampleType(int index){
		return multiSampleTypes_.get(index);
	}

	/**
	 * }`Tv^CṽNHeB̎擾
	 *
	 * }`Tv^CṽNHeBgetMultiSampleTypeCount()Ŏ擾B
	 * @param index CfbNX
	 * @return }`Tv^CṽNHeB
	 */
	virtual u_int getMultiSampleTypeQuality(int index){
		return multiSampleTypeQualities_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * }`TvRtNg̎擾
	 * @return }`TvƐ[xAXeVtH[}bgƂ̃RtNg
	 */
	virtual int getMultiSampleConflictCount() const{
		return multiSampleConflictFormats_.getCount();
	}

	/**
	 * }`TvRtNgtH[}bg̎擾
	 * @param index CfbNX
	 * @return }`TvƃRtNg[xAXeVtH[}bg
	 */
	virtual D3DFORMAT getMultiSampleConflictFormat(int index){
		return multiSampleConflictFormats_.get(index);
	}

	/**
	 * }`TvRtNg^Cv̎擾
	 * @param index CfbNX
	 * @return [xAXeVtH[}bgƃRtNg}`Tv^Cv
	 */
	virtual D3DMULTISAMPLE_TYPE getMultiSampleConflictType(int index){
		return multiSampleConflictTypes_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * _vZX^Cv̎擾
	 * @return _vZX^Cv
	 */
	virtual int getVertexProcessingTypeCount() const{
		return vertexProcessingTypes_.getCount();
	}

	/**
	 * _vZX^Cv̎擾
	 * @param index CfbNX
	 * @return _vZX^Cv
	 */
	virtual VertexProcessingType getVertexProcessingType(int index){
		return vertexProcessingTypes_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * v[e[VԊu̎擾
	 * @return v[e[VԊu
	 */
	virtual int getPresentationIntervalCount() const{
		return presentationInterval_.getCount();
	}

	/**
	 * v[e[VԊu̎擾
	 * @param index CfbNX
	 * @return v[e[VԊu
	 */
	virtual u_int getPresentationInterval(int index){
		return presentationInterval_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return GraphicsDeviceComboInformation̕\L
	 */
	virtual String toString();

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 */
	GraphicsDeviceComboInformation(
		D3DFORMAT adapterFormat, D3DFORMAT backBufferFormat, bool isWindowed);

	/**
	 * fXgN^
	 */
	virtual ~GraphicsDeviceComboInformation();

	/**
	 * 
	 * @param enumeration OtBbNXfoCX
	 * @param deviceInformation OtBbNXfoCX
	 * @return 񋓂true
	 */
	virtual bool enumerate(GraphicsDeviceEnumeration* enumeration,
		GraphicsDeviceInformation* deviceInformation);

	/**
	 * [xAXeVtH[}bg̍\z
	 * @param minimumDepthBits ŏ[xrbg
	 * @param minimumStencilBits ŏXeVrbg
	 */
	virtual void buildDepthStencilFormats(
		u_int minimumDepthBits, u_int minimumStencilBits);

	/**
	 * }`Tv^Cv̍\z
	 */
	virtual void buildMultiSampleType();

	/**
	 * }`TvRtNg̍\z
	 */
	virtual void buildMultiSampleConflict();

	/**
	 * _vZX^Cv̍\z
	 * @param deviceCapability foCX\
	 * @param usesMixedVertexProcessing _vZXgpȂtrue
	 * @param confirmDevice foCXmFC^[tF[X
	 */
	virtual void buildVertexProcessingType(
		const D3DCapacity& deviceCapability, bool usesMixedVertexProcessing,
		ConfirmGraphicsDevice* confirmDevice);

	/**
	 * v[e[VԊu̍\z
	 * @param deviceCapability foCX\
	 */
	virtual void buildPresentationInterval(const D3DCapacity& deviceCapability);

private:
	// Rs[RXgN^̉B
	GraphicsDeviceComboInformation(const GraphicsDeviceComboInformation& copy);

	// Rs[̉B
	void operator =(const GraphicsDeviceComboInformation& copy);

	// [xAXeVtH[}bg
	ArrayList<D3DFORMAT> depthStencilFormats_;
	// }`Tv^Cv
	ArrayList<D3DMULTISAMPLE_TYPE> multiSampleTypes_;
	// }`Tv^CvNHeB
	ArrayList<u_int> multiSampleTypeQualities_;
	// }`TvRtNgtH[}bg
	ArrayList<D3DFORMAT> multiSampleConflictFormats_;
	// }`TvRtNg^Cv
	ArrayList<D3DMULTISAMPLE_TYPE> multiSampleConflictTypes_;
	// _vZX^Cv
	ArrayList<VertexProcessingType> vertexProcessingTypes_;
	// v[e[VԊu
	ArrayList<u_int> presentationInterval_;

	// A_v^ԍ
	int adapterOrdinal_;
	// foCX^Cv
	D3DDEVTYPE deviceType_;
	// A_v^tH[}bg
	D3DFORMAT adapterFormat_;
	// obNobt@tH[}bg
	D3DFORMAT backBufferFormat_;
	// EBhEtO
	bool isWindowed_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_DEVICE_COMBO_INFORMATION_H_
//------------------------------------------------------------------------------
