//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXA_v^wb_
 * @author Junpee
 */

#ifndef GRAPHICS_ADAPTER_INFORMATION_H_
#define GRAPHICS_ADAPTER_INFORMATION_H_

#include <Core/Container/ArrayList.h>

namespace Lamp{

class GraphicsDeviceInformation;

//------------------------------------------------------------------------------
/**
 * OtBbNXA_v^
 */
class GraphicsAdapterInformation{
friend class GraphicsDeviceEnumeration;
public:
	//--------------------------------------------------------------------------
	/**
	 * A_v^ԍ̎擾
	 * @return A_v^ԍ
	 */
	virtual int getAdapterOrdinal(){ return adapterOrdinal_; }

	//--------------------------------------------------------------------------
	/**
	 * A_v^ʎq̎擾
	 * @return A_v^ʎq
	 */
	virtual const D3DAdapterIdentifier& getAdapterIdentifier(){
		return identifier_;
	}

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	//--------------------------------------------------------------------------
	/**
	 * hCo̎擾
	 * @return hCo
	 */
	virtual const String& getDriverName() const{ return driverName_; }

	//--------------------------------------------------------------------------
	/**
	 * fBXvC[h̎擾
	 * @return fBXvC[h
	 */
	virtual int getDisplayModeCount() const{ return displayModes_.getCount(); }

	/**
	 * fBXvC[h̎擾
	 * @param index CfbNX
	 * @return fBXvC[h
	 */
	virtual D3DDISPLAYMODE getDisplayMode(int index){
		return displayModes_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * A_v^tH[}bg̎擾
	 * @return A_v^tH[}bg
	 */
	virtual int getAdapterFormatCount() const{
		return adapterFormats_.getCount();
	}

	/**
	 * A_v^tH[}bg̎擾
	 * @param index CfbNX
	 * @return A_v^tH[}bg
	 */
	virtual D3DFORMAT getAdapterFormat(int index){
		return adapterFormats_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * foCX̎擾
	 * @return foCX
	 */
	virtual int getDeviceCount() const{ return devices_.getCount(); }

	/**
	 * foCX̎擾
	 * @param index CfbNX
	 * @return foCX
	 */
	virtual GraphicsDeviceInformation* getDevice(int index){
		return devices_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return GraphicsAdapterInformation̕\L
	 */
	virtual String toString();

protected:
	/**
	 * RXgN^
	 * @param adapterOrdinal ԍ
	 */
	GraphicsAdapterInformation(int adapterOrdinal);

	/**
	 * fXgN^
	 */
	virtual ~GraphicsAdapterInformation();

	/**
	 * 
	 * @param enumeration OtBbNXfoCX
	 */
	virtual void enumerate(GraphicsDeviceEnumeration* enumeration);

	//--------------------------------------------------------------------------
private:
	// A_v^ԍ
	int adapterOrdinal_;
	// A_v^ʎq
	D3DAdapterIdentifier identifier_;
	// A_v^
	String name_;
	// hCo
	String driverName_;
	// A_v^tH[}bg
	ArrayList<D3DFORMAT> adapterFormats_;
	// fBXvC[h
	ArrayList<D3DDISPLAYMODE> displayModes_;
	// foCX
	ArrayList<GraphicsDeviceInformation*> devices_;

	// Rs[RXgN^̉B
	GraphicsAdapterInformation(const GraphicsAdapterInformation& copy);

	// Rs[̉B
	void operator =(const GraphicsAdapterInformation& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_ADAPTER_INFORMATION_H_
//------------------------------------------------------------------------------
