//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtBbNXfoCXZN^wb_
 * @author Junpee
 */

#ifndef GRAPHICS_DEVICE_SELECTOR_H_
#define GRAPHICS_DEVICE_SELECTOR_H_

namespace Lamp{

class GraphicsAdapterInformation;
class GraphicsDeviceInformation;
class GraphicsDeviceComboInformation;

//------------------------------------------------------------------------------
// ݒt@CǂݍƂvLVfoCXZN^ƂƂ
// tXN[ݒt@Cɏǂ
// ꂩSettingsReaderAWriterΉāAZN^ʂɐݒ肩
// ǂݍݎsƂɑIȂKv
// s̔͂ςZN^CȂ̂ŃvLV
/**
 * OtBbNXfoCXZN^
 */
class GraphicsDeviceSelector{
public:
	/**
	 * RXgN^
	 */
	GraphicsDeviceSelector(){}

	/**
	 * fXgN^
	 */
	virtual ~GraphicsDeviceSelector(){}

	/**
	 * foCXݒ̑I
	 * @param windowHandle EBhEnh
	 * @param startFullscreen tXN[D悵ďȂtrue
	 * @return gpłfoCX݂true
	 */
	virtual bool chooseDeviceSettings(
		HWND windowHandle, bool startFullscreen);

	/**
	 * EBhE[h̍œKȐݒT
	 * @param windowHandle EBhEnh
	 * @param requireHAL n[hEFAANZ[Vvꍇtrue
	 * @param requireREF t@XX^CUvꍇtrue
	 * @return gpłfoCX݂true
	 */
	virtual bool findBestWindowedMode(
		HWND windowHandle, bool requireHAL, bool requireREF) = 0;

	/**
	 * tXN[[h̍œKȐݒT
	 * @param windowHandle EBhEnh
	 * @param requireHAL n[hEFAANZ[Vvꍇtrue
	 * @param requireREF t@XX^CUvꍇtrue
	 * @return gpłfoCX݂true
	 */
	virtual bool findBestFullscreenMode(
		HWND windowHandle, bool requireHAL, bool requireREF) = 0;

protected:
	/**
	 * EChE[hݒ̍\z
	 * @param windowHandle EBhEnh
	 * @param displayMode fBXvC[h
	 * @param bestAdapter œKȃA_v^
	 * @param bestDevice œKȃfoCX
	 * @param bestDeviceCombo œKȃfoCXR{
	 */
	virtual void buildWindowModeSettings(
		HWND windowHandle, const D3DDISPLAYMODE& displayMode,
		GraphicsAdapterInformation* bestAdapter,
		GraphicsDeviceInformation* bestDevice,
		GraphicsDeviceComboInformation* bestDeviceCombo);

	/**
	 * tXN[[hݒ̍\z
	 * @param displayMode fBXvC[h
	 * @param bestAdapter œKȃA_v^
	 * @param bestDevice œKȃfoCX
	 * @param bestDeviceCombo œKȃfoCXR{
	 */
	virtual void buildFullscreenModeSettings(
		const D3DDISPLAYMODE& displayMode,
		GraphicsAdapterInformation* bestAdapter,
		GraphicsDeviceInformation* bestDevice,
		GraphicsDeviceComboInformation* bestDeviceCombo);

private:
	// Rs[RXgN^̉B
	GraphicsDeviceSelector(const GraphicsDeviceSelector& copy);

	// Rs[̉B
	void operator =(const GraphicsDeviceSelector& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of GRAPHICS_DEVICE_SELECTOR_H_
//------------------------------------------------------------------------------

