//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Jwb_
 * @author Junpee
 */

#ifndef CAMERA_H_
#define CAMERA_H_

#include <Graphics/Scene/SceneObject.h>
#include <Graphics/Renderer/Clipping.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * J
 */
class Camera : public SceneObject{
friend class SceneObjectManagerTemplate<Camera>;
friend class CameraManager;
public:
	/**
	 * t@XJEg̎擾
	 * @return t@XJEg
	 */
	virtual int getReferenceCount() const{ return 0; }

	/**
	 * Rs[
	 * @return Rs[ꂽJ
	 */
	virtual Camera* copy() const;

	//--------------------------------------------------------------------------
	// ˉes
	//--------------------------------------------------------------------------
	/**
	 * ˉes̎擾
	 * @return ˉes
	 */
	virtual const Matrix44& getProjectionMatrix(){ return projectionMatrix_; }

	//--------------------------------------------------------------------------
	/**
	 * Ŝꂽp[XyNeBuݒ
	 * @param left ŏXl
	 * @param right őXl
	 * @param bottom ŏYl
	 * @param top őYl
	 * @param nearClip ŏZl
	 * @param farClip őZl
	 */
	virtual void setPerspectiveOffCenter(
		float left, float right, float bottom, float top,
		float nearClip, float farClip){
		left_ = left;
		right_  = right;
		bottom_ = bottom;
		top_ = top;
		nearClip_ = nearClip;
		farClip_ = farClip;
		isPerspective_ = true;
		buildPerspectiveMatrix();
	}

	/**
	 * p[XyNeBuݒ
	 * @param width 
	 * @param height 
	 * @param nearClip ŏZl
	 * @param farClip őZl
	 */
	virtual void setPerspective(
		float width, float height, float nearClip, float farClip){
		left_ = -width * 0.5f;
		right_  = -left_;
		bottom_ = -height * 0.5f;
		top_ = -bottom_;
		nearClip_ = nearClip;
		farClip_ = farClip;
		isPerspective_ = true;
		buildPerspectiveMatrix();
	}

	/**
	 * pɂp[XyNeBuݒ
	 * @param fovY Ỷp
	 * @param aspect AXyNg(width / height)
	 * @param nearClip ŏZl
	 * @param farClip őZl
	 */
	virtual void setPerspectiveFovY(
		float fovY, float aspect, float nearClip, float farClip){
		bottom_ = -nearClip / (1.f / Math::tan(fovY * 0.5f));
		top_ = -bottom_;
		left_ = bottom_ * aspect;
		right_  = -left_;
		nearClip_ = nearClip;
		farClip_ = farClip;
		isPerspective_ = true;
		buildPerspectiveMatrix();
	}

	/**
	 * Ŝꂽseݒ
	 * @param left ŏXl
	 * @param right őXl
	 * @param bottom ŏYl
	 * @param top őYl
	 * @param nearClip ŏZl
	 * @param farClip őZl
	 */
	virtual void setOrthoOffCenter(
		float left, float right, float bottom, float top,
		float nearClip, float farClip){
		left_ = left;
		right_  = right;
		bottom_ = bottom;
		top_ = top;
		nearClip_ = nearClip;
		farClip_ = farClip;
		isPerspective_ = false;
		buildPerspectiveMatrix();
	}

	/**
	 * seݒ
	 * @param width 
	 * @param height 
	 * @param nearClip ŏZl
	 * @param farClip őZl
	 */
	virtual void setOrtho(
		float width, float height, float nearClip, float farClip){
		left_ = -width * 0.5f;
		right_  = -left_;
		bottom_ = -height * 0.5f;
		top_ = -bottom_;
		nearClip_ = nearClip;
		farClip_ = farClip;
		isPerspective_ = false;
		buildPerspectiveMatrix();
	}

	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLeft(){ return left_; }

	/**
	 * E̎擾
	 * @return E
	 */
	virtual float getRight(){ return right_; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getBottom(){ return bottom_; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getTop(){ return top_; }

	//--------------------------------------------------------------------------
	/**
	 * jANbv̎擾
	 * @return jANbv
	 */
	virtual float getNearClip(){ return nearClip_; }

	/**
	 * jANbv̐ݒ
	 * @param nearClip jANbv
	 */
	virtual void setNearClip(float nearClip){
		if(isPerspective_){
			setPerspectiveOffCenter(getLeft(), getRight(),
				getBottom(), getTop(), nearClip, getFarClip());
		}else{
			setOrthoOffCenter(getLeft(), getRight(),
				getBottom(), getTop(), nearClip, getFarClip());
		}
	}

	//--------------------------------------------------------------------------
	/**
	 * t@[Nbv̎擾
	 * @return t@[Nbv
	 */
	virtual float getFarClip(){ return farClip_; }

	/**
	 * t@[Nbv̐ݒ
	 * @param farClip t@[Nbv
	 */
	virtual void setFarClip(float farClip){
		if(isPerspective_){
			setPerspectiveOffCenter(getLeft(), getRight(),
				getBottom(), getTop(), getNearClip(), farClip);
		}else{
			setOrthoOffCenter(getLeft(), getRight(),
				getBottom(), getTop(), getNearClip(), farClip);
		}
	}

	//--------------------------------------------------------------------------
	/**
	 * p[XyNeBuǂ
	 * @return p[XyNeBuȂtrue
	 */
	virtual bool isPerspective(){ return isPerspective_; }

	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getWidth(){ return right_ - left_; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getHeight(){ return top_ - bottom_; }

	//--------------------------------------------------------------------------
	/**
	 * p̎擾
	 * @return p
	 */
	virtual float getFovY(){
		if(!isPerspective_){ return 0.f; }
		return 2.f * Math::atan(1.f / (2.f * nearClip_ / (top_ - bottom_)));
	}

	/**
	 * p̐ݒ
	 * @param fovY p
	 */
	virtual void setFovY(float fovY){
// OffCenterŐݒ肳ĂƂȂ
		Assert(isPerspective_);
		setPerspectiveFovY(fovY, getAspect(), getNearClip(), getFarClip());
	}

	//--------------------------------------------------------------------------
	/**
	 * AXyNg̎擾
	 * @return AXyNg
	 */
	virtual float getAspect(){ return (right_ - left_) / (top_ - bottom_); }

	/**
	 * AXyNg̐ݒ
	 * @param aspect AXyNg
	 */
	virtual void setAspect(float aspect){
// OffCenterŐݒ肳ĂƂȂ
		Assert(isPerspective_);
		setPerspectiveFovY(getFovY(), aspect, getNearClip(), getFarClip());
	}

	//--------------------------------------------------------------------------
	// r[s
	//--------------------------------------------------------------------------
	/**
	 * r[s̎擾
	 * @return r[s
	 */
	virtual const Matrix44& getViewMatrix(){ return viewMatrix_; }

	/**
	 * Jʒu̎擾
	 * @return Jʒu
	 */
	virtual const Vector3& getPosition(){ return position_; }

	/**
	 * J]̎擾
	 * @return J]
	 */
	virtual const Vector3& getRotation(){ return rotation_; }

	//--------------------------------------------------------------------------
	/**
	 * r[s̐ݒ
	 * @param viewMatrix r[s
	 */
	virtual void setViewMatrix(const Matrix44& viewMatrix);

	/**
	 * gXtH[[V̐ݒ
	 * @param rotationXYZ r[XYZ]
	 * @param position r[̈ʒu
	 */
	virtual void setTransformation(
		const Vector3& rotationXYZ, const Vector3& position);

	/**
	 * gXtH[[V̐ݒ
	 * @param rotation r[̎l]
	 * @param position r[̈ʒu
	 */
	virtual void setTransformation(
		const Quaternion& rotation, const Vector3& position);

	/**
	 * bNAbg̐ݒ
	 * @param position r[ʒu
	 * @param target ڕW
	 * @param up xNg
	 */
	virtual void setLookAt(
		const Vector3& position, const Vector3& target, const Vector3& up);

	//--------------------------------------------------------------------------
	// Nbv֌W
	//--------------------------------------------------------------------------
	/**
	 * NbsO
	 * @param boundingSphere oEfBOXtBA
	 * @return NbsOXe[g
	 */
	virtual Clipping::State clipping(const Sphere& boundingSphere);

	/**
	 * NbsO
	 * @param boundingBox oEfBO{bNX
	 * @return NbsOXe[g
	 */
	virtual Clipping::State clipping(const AxisAlignedBox& boundingBox);

	/**
	 * R[i[̎擾
	 *
	 * ȉ̐}̃CfbNXɉăR[i[擾܂B
	 * <pre>
	 *    y+
	 *    |  5----4
	 *    | /|   /|
	 *    |1-+--2 |
	 *    || 6--+-7
	 *    ||/   |/
	 *    |0----3
	 *    +-------- x+
	 *   /
	 *  z+
	 * </pre>
	 * @param index R[i[CfbNX
	 * @return R[i[
	 */
	virtual const Vector3& getCorner(int index){
		Assert(index >= 0);
		Assert(index < 8);
		return corner_[index];
	}

	/**
	 * oEfBOXtBA̎擾
	 * @return oEfBOXtBA
	 */
	virtual const Sphere& getBoundingSphere(){ return boundingSphere_; }

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * Jǂ
	 * @return JȂtrue
	 */
	virtual bool isCamera() const{ return true; }

	//--------------------------------------------------------------------------
protected:
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	Camera(const String& name, Scene* scene);

	/**
	 * fXgN^
	 */
	virtual ~Camera();

	//--------------------------------------------------------------------------
	/**
	 * ˉes̍\z
	 */
	virtual void buildPerspectiveMatrix();

	/**
	 * NbsÕZbgAbv
	 */
	virtual void clippingSetup();

	//--------------------------------------------------------------------------
private:
	// ˉes
	Matrix44 projectionMatrix_;
	// r[s
	Matrix44 viewMatrix_;
	// Nbv
	Plane clipPlane_[6];
	// oEfBOXtBA
	Sphere boundingSphere_;
	// R[i[
	Vector3 corner_[8];
	// ʒu
	Vector3 position_;
	// ]
	Vector3 rotation_;

	// 
	float left_;
	// E
	float right_;
	// 
	float bottom_;
	// 
	float top_;
	// jANbv
	float nearClip_;
	// t@[Nbv
	float farClip_;
	// p[XyNeBuǂ
	bool isPerspective_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CAMERA_H_
//------------------------------------------------------------------------------
