//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ʃwb_
 * @author Junpee
 */

#ifndef INTERSECTION_RESULT_H_
#define INTERSECTION_RESULT_H_

#include <Core/Container/ArrayList.h>
#include <Geometry/System/Intersection.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * 
 */
class IntersectionResult{
public:
	/**
	 * RXgN^
	 */
	IntersectionResult(){}

	/**
	 * fXgN^
	 */
	virtual ~IntersectionResult(){}

	//--------------------------------------------------------------------------
	/**
	 * NA
	 */
	virtual void clear(){ intersections_.clear(); }

	/**
	 * ]
	 */
	virtual void reverse(){
		int count = getCount();
		for(int i = 0; i < count; i++){ intersections_.get(i).reverse(); }
	}

	/**
	 * Ă邩
	 * @return Ătrue
	 */
	virtual bool isIntersected() const{
		return (intersections_.getCount() != 0);
	}

	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual int getCount() const{ return intersections_.getCount(); }

	/**
	 * ̎擾
	 * @param index CfbNX
	 * @return 
	 */
	virtual const Intersection& get(int index) const{
		return intersections_.get(index);
	}

	//--------------------------------------------------------------------------
	/**
	 * ʒu̕ώ擾
	 * @return ʒu̕
	 */
	virtual Vector3 getAveragePosition() const{
		Assert(isIntersected());
		Vector3 result(Vector3::zero);
		int count = getCount();
		for(int i = 0; i < count; i++){ result += get(i).getPosition(); }
		result *= 1.f / count;
		return result;
	}

	/**
	 * ˂̕ώ擾
	 * @return ˂̕
	 */
	virtual Vector3 getAverageRefrection() const{
		Vector3 result(Vector3::zero);
		if(!isIntersected()){ return result; }
		int count = getCount();
		for(int i = 0; i < count; i++){ result += get(i).getRefrection(); }
		result *= 1.f / count;
		return result;
	}

	/**
	 * ő̔ˎ擾
	 * @return ő̔
	 */
	virtual Vector3 getMaxRefrection() const{
		if(!isIntersected()){ return Vector3::zero; }
		Vector3 result(get(0).getRefrection());
		float maxSquaredLength = result.getSquaredLength();
		int count = getCount();
		for(int i = 1; i < count; i++){
			const Vector3& refrection = get(i).getRefrection();
			float squaredLength = refrection.getSquaredLength();
			if(squaredLength > maxSquaredLength){
				result = refrection;
				maxSquaredLength = squaredLength;
			}
		}
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * ̒ǉ
	 * @param intersection 
	 */
	virtual void add(const Intersection& intersection){
		intersections_.add(intersection);
	}

	/**
	 * ̍폜
	 * @param index CfbNX
	 */
	virtual void remove(int index){ intersections_.remove(index); }

	/**
	 * ̍폜
	 * @param intersection 
	 * @return 폜CfbNXB-1ȂYvfB
	 */
	virtual int remove(const Intersection& intersection){
		return intersections_.removeByValue(intersection);
	}

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	IntersectionResult(const IntersectionResult& copy);

	// Rs[̉B
	void operator =(const IntersectionResult& copy);

	//--------------------------------------------------------------------------
	// z
	ArrayList<Intersection> intersections_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of INTERSECTION_RESULT_H_
//------------------------------------------------------------------------------
