//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * wb_
 * @author Junpee
 */

#ifndef INTERSECTION_H_
#define INTERSECTION_H_

#include <Core/Primitive/Vector3.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * 
 *
 * ̃NX͌pȂŉB
 */
class Intersection{
public:
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	Intersection(){}

	//--------------------------------------------------------------------------
	/**
	 * ݒ
	 * @param position ʒu
	 * @param refrection 
	 */
	void set(const Vector3& position, const Vector3& refrection){
		position_ = position;
		refrection_ = refrection;
	}

	/**
	 * ]
	 */
	void reverse(){
		refrection_ = -refrection_;
		position_ = position_ + refrection_;
	}

	/**
	 * r
	 * @param compare rΏ
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Intersection& compare) const{
		return ((position_ == compare.position_) &&
			(refrection_ == compare.refrection_));
	}

	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param position ʒu
	 */
	void setPosition(const Vector3& position){ position_ = position; }

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	const Vector3& getPosition() const{ return position_; }

	//--------------------------------------------------------------------------
	/**
	 * ˂̐ݒ
	 * @param refrection 
	 */
	void setRefrection(const Vector3& refrection){ refrection_ = refrection; }

	/**
	 * ˂̎擾
	 * @return 
	 */
	const Vector3& getRefrection() const{ return refrection_; }

private:
	//--------------------------------------------------------------------------
	// ʒu
	Vector3 position_;
	// 
	Vector3 refrection_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of INTERSECTION_H_
//------------------------------------------------------------------------------
