//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Opwb_
 * @author Junpee
 */

#ifndef TRIANGLE_H_
#define TRIANGLE_H_

#include <Core/Primitive/Vector3.h>
#include <Core/Primitive/Matrix33.h>
#include <Core/Primitive/Matrix34.h>
#include <Core/Primitive/Matrix44.h>

namespace Lamp{

class Intersection;
class AxisAlignedBox;
class Capsule;
class Cone;
class Line;
class OrientedBox;
class Plane;
class Ray;
class Segment;
class Sphere;

//------------------------------------------------------------------------------
/**
 * Op
 *
 * ̃NX͌pȂŉB
 */
class Triangle{
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [Op
	static const Triangle zero;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	inline Triangle(){}

	/**
	 * RXgN^
	 * @param vertex0 _0̏l
	 * @param vertex1 _1̏l
	 * @param vertex2 _2̏l
	 */
	inline Triangle(const Vector3& vertex0, const Vector3& vertex1,
		const Vector3& vertex2){
		vertex_[0] = vertex0;
		vertex_[1] = vertex1;
		vertex_[2] = vertex2;
	}

	/**
	 * RXgN^
	 * @param vertex0x _0Xl
	 * @param vertex0y _0Yl
	 * @param vertex0z _0Zl
	 * @param vertex1x _1Xl
	 * @param vertex1y _1Yl
	 * @param vertex1z _1Zl
	 * @param vertex2x _2Xl
	 * @param vertex2y _2Yl
	 * @param vertex2z _2Zl
	 */
	inline Triangle(float vertex0x, float vertex0y, float vertex0z,
		float vertex1x, float vertex1y, float vertex1z,
		float vertex2x, float vertex2y, float vertex2z){
		vertex_[0].set(vertex0x, vertex0y, vertex0z);
		vertex_[1].set(vertex1x, vertex1y, vertex1z);
		vertex_[2].set(vertex2x, vertex2y, vertex2z);
	}

	/**
	 * RXgN^
	 * @param source lz
	 */
	inline explicit Triangle(const Vector3* const source){
		vertex_[0] = source[0];
		vertex_[1] = source[1];
		vertex_[2] = source[2];
	}

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param vertex0 ݒ肷钸_0
	 * @param vertex1 ݒ肷钸_1
	 * @param vertex2 ݒ肷钸_2
	 */
	inline void set(const Vector3& vertex0, const Vector3& vertex1,
		const Vector3& vertex2){
		vertex_[0] = vertex0;
		vertex_[1] = vertex1;
		vertex_[2] = vertex2;
	}

	/**
	 * l̐ݒ
	 * @param vertex0x ݒ肷钸_0Xl
	 * @param vertex0y ݒ肷钸_0Yl
	 * @param vertex0z ݒ肷钸_0Zl
	 * @param vertex1x ݒ肷钸_1Xl
	 * @param vertex1y ݒ肷钸_1Yl
	 * @param vertex1z ݒ肷钸_1Zl
	 * @param vertex2x ݒ肷钸_2Xl
	 * @param vertex2y ݒ肷钸_2Yl
	 * @param vertex2z ݒ肷钸_2Zl
	 */
	inline void set(float vertex0x, float vertex0y, float vertex0z,
		float vertex1x, float vertex1y, float vertex1z,
		float vertex2x, float vertex2y, float vertex2z){
		vertex_[0].set(vertex0x, vertex0y, vertex0z);
		vertex_[1].set(vertex1x, vertex1y, vertex1z);
		vertex_[2].set(vertex2x, vertex2y, vertex2z);
	}

	/**
	 * l̐ݒ
	 * @param source ݒlz
	 */
	inline void set(const Vector3* const source){
		vertex_[0] = source[0];
		vertex_[1] = source[1];
		vertex_[2] = source[2];
	}

	/**
	 * _̐ݒ
	 * @param index _̃CfbNX
	 * @param vertex ݒ肷钸_
	 */
	inline void setVertex(int index, const Vector3& vertex){
		Assert((index >= 0) && (index < 3));
		vertex_[index] = vertex;
	}

	//--------------------------------------------------------------------------
	// l̎擾
	//--------------------------------------------------------------------------
	/**
	 * _̎擾
	 * @param index _̃CfbNX
	 * @return _
	 */
	inline const Vector3& getVertex(int index) const{
		Assert((index >= 0) && (index < 3));
		return vertex_[index];
	}

	/**
	 * @̎擾
	 * @return @
	 */
	inline Vector3 getNormal() const{
		return Math3D::calculateNormal(vertex_[0], vertex_[1], vertex_[2]);
	}

	//--------------------------------------------------------------------------
	// OpZ
	//--------------------------------------------------------------------------
	/**
	 * [Opǂ
	 * @return [OpȂtrueԂ
	 */
	inline bool isZero() const{
		return epsilonEquals(zero, Math::epsilon);
	}

	//--------------------------------------------------------------------------
	// gXtH[
	//--------------------------------------------------------------------------
	/**
	 * gXtH[
	 * @param matrix Zs
	 * @return ϊ̎Op
	 */
	inline Triangle transform(const Matrix33& matrix) const{
		return Triangle(
			matrix * vertex_[0], matrix * vertex_[1], matrix * vertex_[2]);
	}

	/**
	 * gXtH[
	 * @param matrix Zs
	 * @return ϊ̎Op
	 */
	inline Triangle transform(const Matrix34& matrix) const{
		return Triangle(
			matrix * vertex_[0], matrix * vertex_[1], matrix * vertex_[2]);
	}

	/**
	 * gXtH[
	 * @param matrix Zs
	 * @return ϊ̎Op
	 */
	inline Triangle transform(const Matrix44& matrix) const{
		return Triangle(
			matrix * vertex_[0], matrix * vertex_[1], matrix * vertex_[2]);
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param point 肷_
	 * @return 
	 */
	float getDistance(const Vector3& point) const{
		return Math::sqrt(getSquaredDistance(point));
	}

	/**
	 * _̓
	 * @param point 肷_
	 * @return ̓
	 */
	float getSquaredDistance(const Vector3& point) const;

	//--------------------------------------------------------------------------
	/**
	 * {bNX
	 * @param axisAlignedBox 肷鎲{bNX
	 * @return 
	 */
	float getDistance(const AxisAlignedBox& axisAlignedBox) const{
		return Math::sqrt(getSquaredDistance(axisAlignedBox));
	}

	/**
	 * {bNX̓
	 * @param axisAlignedBox 肷鎲{bNX
	 * @return ̓
	 */
	float getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * JvZ
	 * @param capsule 肷JvZ
	 * @return 
	 */
	float getDistance(const Capsule& capsule) const{
		return Math::sqrt(getSquaredDistance(capsule));
	}

	/**
	 * JvZ̓
	 * @param capsule 肷JvZ
	 * @return ̓
	 */
	float getSquaredDistance(const Capsule& capsule) const;

	//--------------------------------------------------------------------------
	/**
	 * R[
	 * @param cone 肷R[
	 * @return 
	 */
	float getDistance(const Cone& cone) const{
		return Math::sqrt(getSquaredDistance(cone));
	}

	/**
	 * R[̓
	 * @param cone 肷R[
	 * @return ̓
	 */
	float getSquaredDistance(const Cone& cone) const;

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param line 肷郉C
	 * @return 
	 */
	float getDistance(const Line& line) const{
		return Math::sqrt(getSquaredDistance(line));
	}

	/**
	 * C̓
	 * @param line 肷郉C
	 * @return ̓
	 */
	float getSquaredDistance(const Line& line) const;

	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param orientedBox 肷w{bNX
	 * @return 
	 */
	float getDistance(const OrientedBox& orientedBox) const{
		return Math::sqrt(getSquaredDistance(orientedBox));
	}

	/**
	 * w{bNX̓
	 * @param orientedBox 肷w{bNX
	 * @return ̓
	 */
	float getSquaredDistance(const OrientedBox& orientedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * ʋ
	 * @param plane 肷镽
	 * @return 
	 */
	float getDistance(const Plane& plane) const;

	/**
	 * ʋ̓
	 * @param plane 肷镽
	 * @return ̓
	 */
	float getSquaredDistance(const Plane& plane) const{
		float distance = getDistance(plane);
		return (distance * distance);
	}

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param ray 肷郌C
	 * @return 
	 */
	float getDistance(const Ray& ray) const{
		return Math::sqrt(getSquaredDistance(ray));
	}

	/**
	 * C̓
	 * @param ray 肷郌C
	 * @return ̓
	 */
	float getSquaredDistance(const Ray& ray) const;

	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param segment 肷ZOg
	 * @return 
	 */
	float getDistance(const Segment& segment) const{
		return Math::sqrt(getSquaredDistance(segment));
	}

	/**
	 * ZOg̓
	 * @param segment 肷ZOg
	 * @return ̓
	 */
	float getSquaredDistance(const Segment& segment) const;

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param sphere 肷鋅
	 * @return 
	 */
	float getDistance(const Sphere& sphere) const{
		return Math::sqrt(getSquaredDistance(sphere));
	}

	/**
	 * ̓
	 * @param sphere 肷鋅
	 * @return ̓
	 */
	float getSquaredDistance(const Sphere& sphere) const;

	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param triangle 肷Op
	 * @return 
	 */
	float getDistance(const Triangle& triangle) const{
		return Math::sqrt(getSquaredDistance(triangle));
	}

	/**
	 * Op̓
	 * @param triangle 肷Op
	 * @return ̓
	 */
	float getSquaredDistance(const Triangle& triangle) const;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param point 肷_
	 * @param range ͈
	 * @return Ătrue
	 */
	bool intersect(const Vector3& point, float range = Math::epsilon) const;

	//--------------------------------------------------------------------------
	/**
	 * {bNX
	 * @param axisAlignedBox 肷鎲{bNX
	 * @return Ătrue
	 */
	bool intersect(const AxisAlignedBox& axisAlignedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * JvZ
	 * @param capsule 肷JvZ
	 * @return Ătrue
	 */
	bool intersect(const Capsule& capsule) const;

	//--------------------------------------------------------------------------
	/**
	 * R[
	 * @param cone 肷R[
	 * @return Ătrue
	 */
	bool intersect(const Cone& cone) const;

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param line 肷郉C
	 * @return Ătrue
	 */
	bool intersect(const Line& line) const;

	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param orientedBox 肷w{bNX
	 * @return Ătrue
	 */
	bool intersect(const OrientedBox& orientedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * ʌ
	 * @param plane 肷镽
	 * @return Ătrue
	 */
	bool intersect(const Plane& plane) const;

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param ray 肷郌C
	 * @return Ătrue
	 */
	bool intersect(const Ray& ray) const;

	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param segment 肷ZOg
	 * @return Ătrue
	 */
	bool intersect(const Segment& segment) const;

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param sphere 肷鋅
	 * @return Ătrue
	 */
	bool intersect(const Sphere& sphere) const;

	/**
	 * 
	 * @param intersection AԂltrueȂݒ肳Ă
	 * @param sphere 肷鋅
	 * @return Ătrue
	 */
	bool intersect(Intersection* intersection, const Sphere& sphere) const;

	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param triangle 肷Op
	 * @return Ătrue
	 */
	bool intersect(const Triangle& triangle) const;

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * Opǂ
	 * @param target rOp
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Triangle& target) const{
		return (
			(vertex_[0] == target.vertex_[0]) &&
			(vertex_[1] == target.vertex_[1]) &&
			(vertex_[2] == target.vertex_[2]));
	}

	/**
	 * Opǂ
	 * @param target rOp
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(
		const Triangle& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(vertex_[0].epsilonEquals(target.vertex_[0], epsilon)) &&
			(vertex_[1].epsilonEquals(target.vertex_[1], epsilon)) &&
			(vertex_[2].epsilonEquals(target.vertex_[2], epsilon)));
	}

	/**
	 * OpłȂǂ
	 * @param target rOp
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const Triangle& target) const{
		return (
			(vertex_[0] != target.vertex_[0]) ||
			(vertex_[1] != target.vertex_[1]) ||
			(vertex_[2] != target.vertex_[2]));
	}

	/**
	 * OpłȂǂ
	 * @param target rOp
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const Triangle& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(vertex_[0].notEpsilonEquals(target.vertex_[0], epsilon)) ||
			(vertex_[1].notEpsilonEquals(target.vertex_[1], epsilon)) ||
			(vertex_[2].notEpsilonEquals(target.vertex_[2], epsilon)));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return Op̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("{ ( %.8f, %.8f, %.8f ) ( %.8f, %.8f, %.8f ) "
			"( %.8f, %.8f, %.8f ) }",
			vertex_[0].x, vertex_[0].y, vertex_[0].z,
			vertex_[1].x, vertex_[1].y, vertex_[1].z,
			vertex_[2].x, vertex_[2].y, vertex_[2].z);
		return returnString;
	}

private:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// _
	Vector3 vertex_[3];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TRIANGLE_H_
//------------------------------------------------------------------------------
