//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * wb_
 * @author Junpee
 */

#ifndef SPHERE_H_
#define SPHERE_H_

#include <Core/Primitive/Vector3.h>
#include <Core/Primitive/Matrix33.h>
#include <Core/Primitive/Matrix34.h>
#include <Core/Primitive/Matrix44.h>

namespace Lamp{

class Intersection;
class AxisAlignedBox;
class Capsule;
class Cone;
class Line;
class OrientedBox;
class Plane;
class Ray;
class Segment;
class Triangle;

//------------------------------------------------------------------------------
/**
 * 
 *
 * ̃NX͌pȂŉB
 */
class Sphere{
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [
	static const Sphere zero;

	/// Pʋ
	static const Sphere unit;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	inline Sphere(){}

	/**
	 * RXgN^
	 * @param center S̏l
	 * @param radius ȁl
	 */

	inline Sphere(const Vector3& center, float radius) :
		center_(center), radius_(radius){
	}

	/**
	 * RXgN^
	 * @param centerX SX̏l
	 * @param centerY SY̏l
	 * @param centerZ SZ̏l
	 * @param radius ȁl
	 */

	inline Sphere(float centerX, float centerY, float centerZ, float radius) :
		center_(centerX, centerY, centerZ), radius_(radius){
	}

	/**
	 * RXgN^
	 * @param source lz
	 */
	inline explicit Sphere(const float* const source) :
		center_(source[0], source[1], source[2]), radius_(source[3]){
	}

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param center ݒ肷钆S
	 * @param radius ݒ肷锼a
	 */
	inline void set(const Vector3& center, float radius){
		center_ = center;
		radius_ = radius;
	}

	/**
	 * l̐ݒ
	 * @param centerX ݒ肷钆SX
	 * @param centerY ݒ肷钆SY
	 * @param centerZ ݒ肷钆SZ
	 * @param radius ݒ肷锼a
	 */
	inline void set(float centerX, float centerY, float centerZ, float radius){
		center_.set(centerX, centerY, centerZ);
		radius_ = radius;
	}

	/**
	 * l̐ݒ
	 * @param source ݒlz
	 */
	inline void set(const float* const source){
		center_.set(source[0], source[1], source[2]);
		radius_ = source[3];
	}

	/**
	 * S̐ݒ
	 * @param centerX ݒ肷钆SX
	 * @param centerY ݒ肷钆SY
	 * @param centerZ ݒ肷钆SZ
	 */
	inline void setCenter(float centerX, float centerY, float centerZ){
		center_.set(centerX, centerY, centerZ);
	}

	/**
	 * S̐ݒ
	 * @param center ݒ肷钆S
	 */
	inline void setCenter(const Vector3& center){ center_ = center; }

	/**
	 * a̐ݒ
	 * @param radius ݒ肷锼a
	 */
	inline void setRadius(float radius){ radius_ = radius; }

	//--------------------------------------------------------------------------
	// l̎擾
	//--------------------------------------------------------------------------
	/**
	 * S̎擾
	 * @return S
	 */
	inline const Vector3& getCenter() const{ return center_; }

	/**
	 * a̎擾
	 * @return a
	 */
	inline float getRadius() const{ return radius_; }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * }[W
	 * @param target }[W鋅
	 * @return }[Wꂽ
	 */
	inline const Sphere& merge(const Sphere& target){
		Vector3 direction = target.center_ - center_;
		// ʒuɑ݂鋅
		if(direction.isZero()){
			if(target.radius_ > radius_){ radius_ = target.radius_; }
			return *this;
		}
		float distance = direction.getLength();
		// ^[Qbg̓ɂ
		if(radius_ >= target.radius_ + distance){ return *this; }
		// ^[Qbg̓Ɏ
		if(target.radius_ >= radius_ + distance){
			*this = target;
			return *this;
		}
		// ݂dȂĂȂ
		direction *= (1.f / distance);
		center_ = ((center_ - direction * radius_) +
			(target.center_ + direction * target.radius_)) * 0.5f;
		radius_ = (radius_ + target.radius_ + distance) * 0.5f;
		return *this;
	}

	/**
	 * }[W
	 *
	 * SB
	 * K؂ȒSappendgpꍇƔׂāA傫ȂĂ܂B
	 * @param target }[WxNg
	 * @return }[Wꂽ
	 */
	inline const Sphere& merge(const Vector3& target){
		Vector3 direction = target - center_;
		// SƓʒuɑ
		if(direction.isZero()){ return *this; }
		float distance = direction.getLength();
		// xNgȂ牽Ȃ
		if(distance <= radius_){ return *this; }
		// xNgOɂ̂ŒS𓮂A
		direction *= (1.f / distance);
		center_ = ((center_ - direction * radius_) + target) * 0.5f;
		radius_ = (radius_ + distance) * 0.5f;
		return *this;
	}

	/**
	 * ǉ
	 *
	 * S͓ȂBK؂ȒSݒ肳ĂԂŎgpB
	 * @param target ǉxNg
	 * @return ǉꂽ
	 */
	inline const Sphere& append(const Vector3& target){
		Vector3 direction = target - center_;
		// SƓʒuɑ
		if(direction.isZero()){ return *this; }
		float distance = direction.getLength();
		// OȂgBS͓Ȃ
		if(distance > radius_){ radius_ = distance; }
		return *this;
	}

	//--------------------------------------------------------------------------
	/**
	 * [ǂ
	 * @return [ȂtrueԂ
	 */
	inline bool isZero() const{
		return (Math::abs(radius_) <= Math::epsilon);
	}

	/**
	 * Pʋǂ
	 * @return PʋȂtrueԂ
	 */
	inline bool isUnit() const{
		return (Math::abs(radius_ - 1.f) <= Math::epsilon);
	}

	//--------------------------------------------------------------------------
	// gXtH[
	//--------------------------------------------------------------------------
	/**
	 * gXtH[
	 * @param matrix Zs
	 * @return ϊ̋
	 */
	inline Sphere transform(const Matrix33& matrix) const{
		return Sphere(matrix * center_, radius_);
	}

	/**
	 * gXtH[
	 * @param matrix Zs
	 * @return ϊ̋
	 */
	inline Sphere transform(const Matrix34& matrix) const{
		return Sphere(matrix * center_, radius_);
	}

	/**
	 * gXtH[
	 * @param matrix Zs
	 * @return ϊ̋
	 */
	inline Sphere transform(const Matrix44& matrix) const{
		return Sphere(matrix * center_, radius_);
	}

	//--------------------------------------------------------------------------
	/**
	 * XP[LgXtH[
	 *
	 * ԃXP[̑傫Ȏɂ킹Ĕac݂܂B
	 * @param matrix Zs
	 * @return ϊ̋
	 */
	inline Sphere scaledTransform(const Matrix33& matrix) const{
		// xNg(1,0,0),(0,1,0),(0,0,1)ϊčŒ̒𔼌aɏZ
		float maxSquardLength = 0.f;
		for(int i = 0; i < 3; i++){
			float squaredLength =
				matrix.m[0][i] * matrix.m[0][i] +
				matrix.m[1][i] * matrix.m[1][i] +
				matrix.m[2][i] * matrix.m[2][i];
			if(squaredLength > maxSquardLength){
				maxSquardLength = squaredLength;
			}
		}
		return Sphere(matrix * center_, radius_ * Math::sqrt(maxSquardLength));
	}

	/**
	 * XP[LgXtH[
	 *
	 * ԃXP[̑傫Ȏɂ킹Ĕac݂܂B
	 * @param matrix Zs
	 * @return ϊ̋
	 */
	inline Sphere scaledTransform(const Matrix34& matrix) const{
		// xNg(1,0,0),(0,1,0),(0,0,1)ϊčŒ̒𔼌aɏZ
		float maxSquardLength = 0.f;
		for(int i = 0; i < 3; i++){
			float squaredLength =
				matrix.m[0][i] * matrix.m[0][i] +
				matrix.m[1][i] * matrix.m[1][i] +
				matrix.m[2][i] * matrix.m[2][i];
			if(squaredLength > maxSquardLength){
				maxSquardLength = squaredLength;
			}
		}
		return Sphere(matrix * center_, radius_ * Math::sqrt(maxSquardLength));
	}

	/**
	 * XP[LgXtH[
	 *
	 * ԃXP[̑傫Ȏɂ킹Ĕac݂܂B
	 * @param matrix Zs
	 * @return ϊ̋
	 */
	inline Sphere scaledTransform(const Matrix44& matrix) const{
		// xNg(1,0,0),(0,1,0),(0,0,1)ϊčŒ̒𔼌aɏZ
		float maxSquardLength = 0.f;
		for(int i = 0; i < 3; i++){
			float squaredLength =
				matrix.m[0][i] * matrix.m[0][i] +
				matrix.m[1][i] * matrix.m[1][i] +
				matrix.m[2][i] * matrix.m[2][i];
			if(squaredLength > maxSquardLength){
				maxSquardLength = squaredLength;
			}
		}
		return Sphere(matrix * center_, radius_ * Math::sqrt(maxSquardLength));
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param point 肷_
	 * @return 
	 */
	float getDistance(const Vector3& point) const{
		return Math::sqrt(getSquaredDistance(point));
	}

	/**
	 * _̓
	 * @param point 肷_
	 * @return ̓
	 */
	float getSquaredDistance(const Vector3& point) const;

	//--------------------------------------------------------------------------
	/**
	 * {bNX
	 * @param axisAlignedBox 肷鎲{bNX
	 * @return 
	 */
	float getDistance(const AxisAlignedBox& axisAlignedBox) const{
		return Math::sqrt(getSquaredDistance(axisAlignedBox));
	}

	/**
	 * {bNX̓
	 * @param axisAlignedBox 肷鎲{bNX
	 * @return ̓
	 */
	float getSquaredDistance(const AxisAlignedBox& axisAlignedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * JvZ
	 * @param capsule 肷JvZ
	 * @return 
	 */
	float getDistance(const Capsule& capsule) const{
		return Math::sqrt(getSquaredDistance(capsule));
	}

	/**
	 * JvZ̓
	 * @param capsule 肷JvZ
	 * @return ̓
	 */
	float getSquaredDistance(const Capsule& capsule) const;

	//--------------------------------------------------------------------------
	/**
	 * R[
	 * @param cone 肷R[
	 * @return 
	 */
	float getDistance(const Cone& cone) const{
		return Math::sqrt(getSquaredDistance(cone));
	}

	/**
	 * R[̓
	 * @param cone 肷R[
	 * @return ̓
	 */
	float getSquaredDistance(const Cone& cone) const;

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param line 肷郉C
	 * @return 
	 */
	float getDistance(const Line& line) const{
		return Math::sqrt(getSquaredDistance(line));
	}

	/**
	 * C̓
	 * @param line 肷郉C
	 * @return ̓
	 */
	float getSquaredDistance(const Line& line) const;

	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param orientedBox 肷w{bNX
	 * @return 
	 */
	float getDistance(const OrientedBox& orientedBox) const{
		return Math::sqrt(getSquaredDistance(orientedBox));
	}

	/**
	 * w{bNX̓
	 * @param orientedBox 肷w{bNX
	 * @return ̓
	 */
	float getSquaredDistance(const OrientedBox& orientedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * ʋ
	 * @param plane 肷镽
	 * @return 
	 */
	float getDistance(const Plane& plane) const;

	/**
	 * ʋ̓
	 * @param plane 肷镽
	 * @return ̓
	 */
	float getSquaredDistance(const Plane& plane) const{
		float distance = getDistance(plane);
		return (distance * distance);
	}

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param ray 肷郌C
	 * @return 
	 */
	float getDistance(const Ray& ray) const{
		return Math::sqrt(getSquaredDistance(ray));
	}

	/**
	 * C̓
	 * @param ray 肷郌C
	 * @return ̓
	 */
	float getSquaredDistance(const Ray& ray) const;

	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param segment 肷ZOg
	 * @return 
	 */
	float getDistance(const Segment& segment) const{
		return Math::sqrt(getSquaredDistance(segment));
	}

	/**
	 * ZOg̓
	 * @param segment 肷ZOg
	 * @return ̓
	 */
	float getSquaredDistance(const Segment& segment) const;

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param sphere 肷鋅
	 * @return 
	 */
	float getDistance(const Sphere& sphere) const{
		return Math::sqrt(getSquaredDistance(sphere));
	}

	/**
	 * ̓
	 * @param sphere 肷鋅
	 * @return ̓
	 */
	float getSquaredDistance(const Sphere& sphere) const;

	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param triangle 肷Op
	 * @return 
	 */
	float getDistance(const Triangle& triangle) const{
		return Math::sqrt(getSquaredDistance(triangle));
	}

	/**
	 * Op̓
	 * @param triangle 肷Op
	 * @return ̓
	 */
	float getSquaredDistance(const Triangle& triangle) const;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param point 肷_
	 * @return Ătrue
	 */
	bool intersect(const Vector3& point) const;

	//--------------------------------------------------------------------------
	/**
	 * {bNX
	 * @param axisAlignedBox 肷鎲{bNX
	 * @return Ătrue
	 */
	bool intersect(const AxisAlignedBox& axisAlignedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * JvZ
	 * @param capsule 肷JvZ
	 * @return Ătrue
	 */
	bool intersect(const Capsule& capsule) const;

	//--------------------------------------------------------------------------
	/**
	 * R[
	 * @param cone 肷R[
	 * @return Ătrue
	 */
	bool intersect(const Cone& cone) const;

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param line 肷郉C
	 * @return Ătrue
	 */
	bool intersect(const Line& line) const;

	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param orientedBox 肷w{bNX
	 * @return Ătrue
	 */
	bool intersect(const OrientedBox& orientedBox) const;

	//--------------------------------------------------------------------------
	/**
	 * ʌ
	 * @param plane 肷镽
	 * @return Ătrue
	 */
	bool intersect(const Plane& plane) const;

	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param ray 肷郌C
	 * @return Ătrue
	 */
	bool intersect(const Ray& ray) const;

	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param segment 肷ZOg
	 * @return Ătrue
	 */
	bool intersect(const Segment& segment) const;

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param sphere 肷鋅
	 * @return Ătrue
	 */
	bool intersect(const Sphere& sphere) const;

	/**
	 * 
	 * @param intersection AԂltrueȂݒ肳Ă
	 * @param sphere 肷鋅
	 * @return Ătrue
	 */
	bool intersect(Intersection* intersection, const Sphere& sphere) const;

	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param triangle 肷Op
	 * @return Ătrue
	 */
	bool intersect(const Triangle& triangle) const;

	/**
	 * Op
	 * @param intersection AԂltrueȂݒ肳Ă
	 * @param triangle 肷Op
	 * @return Ătrue
	 */
	bool intersect(Intersection* intersection, const Triangle& triangle) const;

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * ǂ
	 * @param target r鋅
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Sphere& target) const{
		return ((center_ == target.center_) && (radius_ == target.radius_));
	}

	/**
	 * ǂ
	 * @param target r鋅
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(
		const Sphere& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (center_.epsilonEquals(target.center_, epsilon) &&
			(Math::abs(radius_ - target.radius_) <= epsilon));
	}

	/**
	 * łȂǂ
	 * @param target r鋅
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const Sphere& target) const{
		return ((center_ != target.center_) || (radius_ != target.radius_));
	}

	/**
	 * łȂǂ
	 * @param target r鋅
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const Sphere& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (center_.notEpsilonEquals(target.center_, epsilon) ||
			(Math::abs(radius_ - target.radius_) > epsilon));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("{ ( %.8f, %.8f, %.8f ) %.8f }",
			center_.x, center_.y, center_.z, radius_);
		return returnString;
	}

private:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	// S
	Vector3 center_;
	// a
	float radius_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPHERE_H_
//------------------------------------------------------------------------------
