//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * bVWIgwb_
 * @author Junpee
 */

#ifndef MESH_GEOMETRY_H_
#define MESH_GEOMETRY_H_

namespace Lamp{

class IntersectionResult;

//------------------------------------------------------------------------------
/**
 * bVWIg
 */
class MeshGeometry{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	MeshGeometry();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit MeshGeometry(const MeshGeometry& copy);

	/**
	 * Rs[
	 * @param copy Rs[
	 * @return Rs[ꂽbVWIg
	 */
	virtual const MeshGeometry& operator =(const MeshGeometry& copy);

	/**
	 * fXgN^
	 */
	virtual ~MeshGeometry();

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param sphere 肷鋅
	 * @return Ătrue
	 */
	virtual bool intersect(const Sphere& sphere) const{
		Assert(false);
		return false;
	}

	/**
	 * 
	 * @param sphere 肷鋅
	 * @param result 
	 */
	virtual void intersect(
		IntersectionResult* result, const Sphere& sphere) const{
		Assert(false);
	}

	/**
	 * oEfBO
	 * @param sphere 肷鋅
	 * @return oEfBOƌĂtrue
	 */
	virtual bool intersectBounding(const Sphere& sphere) const{
		Assert(false);
		return false;
	}

	/**
	 * bV
	 * @param sphere 肷鋅
	 * @return bVƌĂtrue
	 */
	virtual bool intersectMesh(const Sphere& sphere) const{
		Assert(false);
		return false;
	}

	/**
	 * bV
	 * @param sphere 肷鋅
	 * @param result 
	 */
	virtual void intersectMesh(
		IntersectionResult* result, const Sphere& sphere) const{
		Assert(false);
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MESH_GEOMETRY_H_
//------------------------------------------------------------------------------
