//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ό`bVWIgwb_
 * @author Junpee
 */

#ifndef DEFORMED_MESH_GEOMETRY_H_
#define DEFORMED_MESH_GEOMETRY_H_

#include <Geometry/Mesh/MeshGeometry.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ό`bVWIg
 */
class DeformedMeshGeometry : public MeshGeometry{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	DeformedMeshGeometry();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit DeformedMeshGeometry(const DeformedMeshGeometry& copy);

	/**
	 * Rs[
	 * @param copy Rs[
	 * @return Rs[ꂽό`bVWIg
	 */
	virtual const DeformedMeshGeometry& operator =(
		const DeformedMeshGeometry& copy);

	/**
	 * fXgN^
	 */
	virtual ~DeformedMeshGeometry();

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param sphere 肷鋅
	 * @return Ătrue
	 */
	virtual bool intersect(const Sphere& sphere) const;

	/**
	 * 
	 * @param sphere 肷鋅
	 * @param result 
	 */
	virtual void intersect(
		IntersectionResult* result, const Sphere& sphere) const;

	/**
	 * oEfBO
	 * @param sphere 肷鋅
	 * @return oEfBOƌĂtrue
	 */
	virtual bool intersectBounding(const Sphere& sphere) const;

	/**
	 * bV
	 * @param sphere 肷鋅
	 * @return bVƌĂtrue
	 */
	virtual bool intersectMesh(const Sphere& sphere) const;

	/**
	 * bV
	 * @param sphere 肷鋅
	 * @param result 
	 */
	virtual void intersectMesh(
		IntersectionResult* result, const Sphere& sphere) const;

	//--------------------------------------------------------------------------
	// gCAO
	//--------------------------------------------------------------------------
	/**
	 * gCAO̐ݒ
	 * @param triangleCount gCAO
	 */
	virtual void setTriangleCount(int triangleCount);

	/**
	 * gCAO̎擾
	 * @return gCAO
	 */
	virtual int getTriangleCount() const{ return triangleCount_; }

	//--------------------------------------------------------------------------
	/**
	 * gCAO̐ݒ
	 * @param index CfbNX
	 * @param triangle gCAO
	 */
	virtual void setTriangle(int index, const Triangle& triangle){
		Assert((index >= 0) && (index < triangleCount_));
		triangles_[index] = triangle;
	}

	/**
	 * gCAO̎擾
	 * @param index CfbNX
	 * @return gCAO
	 */
	virtual const Triangle& getTriangle(int index) const{
		Assert((index >= 0) && (index < triangleCount_));
		return triangles_[index];
	}

	//--------------------------------------------------------------------------
	// oEfBO
	//--------------------------------------------------------------------------
	/**
	 * oEfBO̎Zo
	 */
	virtual void calculateBounding();

	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̐ݒ
	 * @param boundingBox oEfBO{bNX
	 */
	virtual void setBoundingBox(const AxisAlignedBox& boundingBox){
		boundingBox_ = boundingBox;
	}

	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual const AxisAlignedBox& getBoundingBox() const{ return boundingBox_; }

	//--------------------------------------------------------------------------
	/**
	 * oEfBOXtBA̐ݒ
	 * @param boundingSphere oEfBOXtBA
	 */
	virtual void setBoundingSphere(const Sphere& boundingSphere){
		boundingSphere_ = boundingSphere;
	}

	/**
	 * oEfBOXtBA̎擾
	 * @return oEfBOXtBA
	 */
	virtual const Sphere& getBoundingSphere() const{
		return boundingSphere_;
	}

protected:
	//--------------------------------------------------------------------------
	/**
	 * ό`bVWIgf[^̃Rs[
	 * @param copy Rs[
	 */
	virtual void copyDeformedMeshGeometryData(const DeformedMeshGeometry& copy);

private:
	//--------------------------------------------------------------------------
	// oEfBO{bNX
	AxisAlignedBox boundingBox_;
	// oEfBOXtBA
	Sphere boundingSphere_;
	// gCAOz
	Triangle* triangles_;
	// gCAO
	int triangleCount_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of DEFORMED_MESH_GEOMETRY_H_
//------------------------------------------------------------------------------
