//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ZOgwb_
 * @author Junpee
 */

#ifndef SEGMENT_INTERSECTION_H_
#define SEGMENT_INTERSECTION_H_

namespace Lamp{

class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * ZOg
 */
class SegmentIntersection{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param segment ZOg
	 * @param point _
	 * @param range ͈
	 * @return Ătrue
	 */
	static bool intersect(const Segment& segment, const Vector3& point,
		float range = Math::epsilon);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param segment0 ZOg
	 * @param segment1 ZOg
	 * @param range ͈
	 * @return Ătrue
	 */
	static bool intersect(const Segment& segment0, const Segment& segment1,
		float range = Math::epsilon);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param segment ZOg
	 * @param sphere 
	 * @return Ătrue
	 */
	static bool intersect(const Segment& segment, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param segment ZOg
	 * @param triangle Op
	 * @return Ătrue
	 */
	static bool intersect(const Segment& segment, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	SegmentIntersection();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SEGMENT_INTERSECTION_H_
//------------------------------------------------------------------------------
