//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ʌwb_
 * @author Junpee
 */

#ifndef PLANE_INTERSECTION_H_
#define PLANE_INTERSECTION_H_

namespace Lamp{

class Plane;
class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * ʌ
 */
class PlaneIntersection{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param plane 
	 * @param point _
	 * @param range ͈
	 * @return Ătrue
	 */
	static bool intersect(const Plane& plane, const Vector3& point,
		float range = Math::epsilon);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ʌ
	 * @param plane0 
	 * @param plane1 
	 * @return Ătrue
	 */
	static bool intersect(const Plane& plane0, const Plane& plane1);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param plane 
	 * @param ray C
	 * @return Ătrue
	 */
	static bool intersect(const Plane& plane, const Ray& ray);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param plane 
	 * @param segment ZOg
	 * @return Ătrue
	 */
	static bool intersect(const Plane& plane, const Segment& segment);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param plane 
	 * @param sphere 
	 * @return Ătrue
	 */
	static bool intersect(const Plane& plane, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param plane 
	 * @param triangle Op
	 * @return Ătrue
	 */
	static bool intersect(const Plane& plane, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	PlaneIntersection();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PLANE_INTERSECTION_H_
//------------------------------------------------------------------------------
