//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * w{bNXwb_
 * @author Junpee
 */

#ifndef ORIENTED_BOX_INTERSECTION_H_
#define ORIENTED_BOX_INTERSECTION_H_

namespace Lamp{

class OrientedBox;
class Plane;
class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * w{bNX
 */
class OrientedBoxIntersection{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param ob w{bNX
	 * @param point _
	 * @return Ătrue
	 */
	static bool intersect(const OrientedBox& ob, const Vector3& point);

	//--------------------------------------------------------------------------
	// w{bNX
	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param ob0 w{bNX
	 * @param ob1 w{bNX
	 * @return Ătrue
	 */
	static bool intersect(const OrientedBox& ob0, const OrientedBox& ob1);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ʌ
	 * @param ob w{bNX
	 * @param plane 
	 * @return Ătrue
	 */
	static bool intersect(const OrientedBox& ob, const Plane& plane);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param ob w{bNX
	 * @param ray C
	 * @return Ătrue
	 */
	static bool intersect(const OrientedBox& ob, const Ray& ray);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param ob w{bNX
	 * @param segment ZOg
	 * @return Ătrue
	 */
	static bool intersect(const OrientedBox& ob, const Segment& segment);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param ob w{bNX
	 * @param sphere 
	 * @return Ătrue
	 */
	static bool intersect(const OrientedBox& ob, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param ob w{bNX
	 * @param triangle Op
	 * @return Ătrue
	 */
	static bool intersect(const OrientedBox& ob, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	OrientedBoxIntersection();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ORIENTED_BOX_INTERSECTION_H_
//------------------------------------------------------------------------------
