//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Cwb_
 * @author Junpee
 */

#ifndef LINE_INTERSECTION_H_
#define LINE_INTERSECTION_H_

namespace Lamp{

class Line;
class OrientedBox;
class Plane;
class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * C
 */
class LineIntersection{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param line C
	 * @param point _
	 * @param range ͈
	 * @return Ătrue
	 */
	static bool intersect(const Line& line, const Vector3& point,
		float range = Math::epsilon);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param line0 C
	 * @param line1 C
	 * @param range ͈
	 * @return Ătrue
	 */
	static bool intersect(const Line& line0, const Line& line1,
		float range = Math::epsilon);

	//--------------------------------------------------------------------------
	// w{bNX
	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param line C
	 * @param ob w{bNX
	 * @return Ătrue
	 */
	static bool intersect(const Line& line, const OrientedBox& ob);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ʌ
	 * @param line C
	 * @param plane 
	 * @return Ătrue
	 */
	static bool intersect(const Line& line, const Plane& plane);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param line C
	 * @param ray C
	 * @param range ͈
	 * @return Ătrue
	 */
	static bool intersect(const Line& line, const Ray& ray,
		float range = Math::epsilon);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param line C
	 * @param segment ZOg
	 * @param range ͈
	 * @return Ătrue
	 */
	static bool intersect(const Line& line, const Segment& segment,
		float range = Math::epsilon);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param line C
	 * @param sphere 
	 * @return Ătrue
	 */
	static bool intersect(const Line& line, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param line C
	 * @param triangle Op
	 * @return Ătrue
	 */
	static bool intersect(const Line& line, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	LineIntersection();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LINE_INTERSECTION_H_
//------------------------------------------------------------------------------
