//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JvZwb_
 * @author Junpee
 */

#ifndef CAPSULE_INTERSECTION_H_
#define CAPSULE_INTERSECTION_H_

namespace Lamp{

class Capsule;
class Cone;
class Line;
class OrientedBox;
class Plane;
class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * JvZ
 */
class CapsuleIntersection{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param capsule JvZ
	 * @param point _
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Vector3& point);

	//--------------------------------------------------------------------------
	// JvZ
	//--------------------------------------------------------------------------
	/**
	 * JvZ
	 * @param capsule0 JvZ
	 * @param capsule1 JvZ
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule0, const Capsule& capsule1);

	//--------------------------------------------------------------------------
	// R[
	//--------------------------------------------------------------------------
	/**
	 * R[
	 * @param capsule JvZ
	 * @param cone R[
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Cone& cone);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param capsule JvZ
	 * @param line C
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Line& line);

	//--------------------------------------------------------------------------
	// w{bNX
	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param capsule JvZ
	 * @param ob w{bNX
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const OrientedBox& ob);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ʌ
	 * @param capsule JvZ
	 * @param plane 
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Plane& plane);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param capsule JvZ
	 * @param ray C
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Ray& ray);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param capsule JvZ
	 * @param segment ZOg
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Segment& segment);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param capsule JvZ
	 * @param sphere 
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param capsule JvZ
	 * @param triangle Op
	 * @return Ătrue
	 */
	static bool intersect(const Capsule& capsule, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	CapsuleIntersection();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CAPSULE_INTERSECTION_H_
//------------------------------------------------------------------------------
