//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {bNXwb_
 * @author Junpee
 */

#ifndef AXIS_ALIGNED_BOX_INTERSECTION_H_
#define AXIS_ALIGNED_BOX_INTERSECTION_H_

namespace Lamp{

class AxisAlignedBox;
class Capsule;
class Cone;
class Line;
class OrientedBox;
class Plane;
class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * {bNX
 */
class AxisAlignedBoxIntersection{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param aab {bNX
	 * @param point _
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Vector3& point);

	//--------------------------------------------------------------------------
	// {bNX
	//--------------------------------------------------------------------------
	/**
	 * {bNX
	 * @param aab0 {bNX
	 * @param aab1 {bNX
	 * @return Ătrue
	 */
	static bool intersect(
		const AxisAlignedBox& aab0, const AxisAlignedBox& aab1);

	//--------------------------------------------------------------------------
	// JvZ
	//--------------------------------------------------------------------------
	/**
	 * JvZ
	 * @param aab {bNX
	 * @param capsule JvZ
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Capsule& capsule);

	//--------------------------------------------------------------------------
	// R[
	//--------------------------------------------------------------------------
	/**
	 * R[
	 * @param aab {bNX
	 * @param cone R[
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Cone& cone);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param aab {bNX
	 * @param line C
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Line& line);

	//--------------------------------------------------------------------------
	// w{bNX
	//--------------------------------------------------------------------------
	/**
	 * w{bNX
	 * @param aab {bNX
	 * @param ob w{bNX
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const OrientedBox& ob);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ʌ
	 * @param aab {bNX
	 * @param plane 
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Plane& plane);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C
	 * @param aab {bNX
	 * @param ray C
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Ray& ray);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg
	 * @param aab {bNX
	 * @param segment ZOg
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Segment& segment);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param aab {bNX
	 * @param sphere 
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op
	 * @param aab {bNX
	 * @param triangle Op
	 * @return Ătrue
	 */
	static bool intersect(const AxisAlignedBox& aab, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	AxisAlignedBoxIntersection();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of AXIS_ALIGNED_BOX_INTERSECTION_H_
//------------------------------------------------------------------------------
