//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * wb_
 * @author Junpee
 */

#ifndef SPHERE_DISTANCE_H_
#define SPHERE_DISTANCE_H_

namespace Lamp{

class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * 
 */
class SphereDistance{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _̓
	 * @param sphere 
	 * @param point _
	 * @return ̓
	 */
	static float squaredDistance(const Sphere& sphere, const Vector3& point);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̓
	 * @param sphere0 
	 * @param sphere1 
	 * @return ̓
	 */
	static float squaredDistance(const Sphere& sphere0, const Sphere& sphere1);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op̓
	 * @param sphere 
	 * @param triangle Op
	 * @return ̓
	 */
	static float squaredDistance(
		const Sphere& sphere, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	SphereDistance();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SPHERE_DISTANCE_H_
//------------------------------------------------------------------------------
