//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ZOgwb_
 * @author Junpee
 */

#ifndef SEGMENT_DISTANCE_H_
#define SEGMENT_DISTANCE_H_

namespace Lamp{

class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * ZOg
 */
class SegmentDistance{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _̓
	 * @param segment ZOg
	 * @param point _
	 * @return ̓
	 */
	static float squaredDistance(const Segment& segment, const Vector3& point);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ̓
	 * @param segment0 ZOg
	 * @param segment1 ZOg
	 * @return ̓
	 */
	static float squaredDistance(
		const Segment& segment0, const Segment& segment1);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̓
	 * @param segment ZOg
	 * @param sphere 
	 * @return ̓
	 */
	static float squaredDistance(const Segment& segment, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op̓
	 * @param segment ZOg
	 * @param triangle Op
	 * @return ̓
	 */
	static float squaredDistance(
		const Segment& segment, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	SegmentDistance();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SEGMENT_DISTANCE_H_
//------------------------------------------------------------------------------
