//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Cwb_
 * @author Junpee
 */

#ifndef RAY_DISTANCE_H_
#define RAY_DISTANCE_H_

namespace Lamp{

class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * C
 */
class RayDistance{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _̓
	 * @param ray C
	 * @param point _
	 * @return ̓
	 */
	static float squaredDistance(const Ray& ray, const Vector3& point);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * ̓
	 * @param ray0 C
	 * @param ray1 C
	 * @return ̓
	 */
	static float squaredDistance(const Ray& ray0, const Ray& ray1);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg̓
	 * @param ray C
	 * @param segment ZOg
	 * @return ̓
	 */
	static float squaredDistance(const Ray& ray, const Segment& segment);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̓
	 * @param ray C
	 * @param sphere 
	 * @return ̓
	 */
	static float squaredDistance(const Ray& ray, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op̓
	 * @param ray C
	 * @param triangle Op
	 * @return ̓
	 */
	static float squaredDistance(const Ray& ray, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	RayDistance();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RAY_DISTANCE_H_
//------------------------------------------------------------------------------
