//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * R[wb_
 * @author Junpee
 */

#ifndef CONE_DISTANCE_H_
#define CONE_DISTANCE_H_

namespace Lamp{

class Cone;
class Line;
class OrientedBox;
class Plane;
class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * R[
 */
class ConeDistance{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _̓
	 * @param cone R[
	 * @param point _
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone, const Vector3& point);

	//--------------------------------------------------------------------------
	// R[
	//--------------------------------------------------------------------------
	/**
	 * R[̓
	 * @param cone0 R[
	 * @param cone1 R[
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone0, const Cone& cone1);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C̓
	 * @param cone R[
	 * @param line C
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone, const Line& line);

	//--------------------------------------------------------------------------
	// w{bNX
	//--------------------------------------------------------------------------
	/**
	 * w{bNX̓
	 * @param cone R[
	 * @param ob w{bNX
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone, const OrientedBox& ob);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ʋ
	 * @param cone R[
	 * @param plane 
	 * @return 
	 */
	static float distance(const Cone& cone, const Plane& plane);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C̓
	 * @param cone R[
	 * @param ray C
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone, const Ray& ray);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg̓
	 * @param cone R[
	 * @param segment ZOg
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone, const Segment& segment);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̓
	 * @param cone R[
	 * @param sphere 
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op̓
	 * @param cone R[
	 * @param triangle Op
	 * @return ̓
	 */
	static float squaredDistance(const Cone& cone, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	ConeDistance();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CONE_DISTANCE_H_
//------------------------------------------------------------------------------
