//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * JvZwb_
 * @author Junpee
 */

#ifndef CAPSULE_DISTANCE_H_
#define CAPSULE_DISTANCE_H_

namespace Lamp{

class Capsule;
class Cone;
class Line;
class OrientedBox;
class Plane;
class Ray;
class Segment;
class Sphere;
class Triangle;

//------------------------------------------------------------------------------
/**
 * JvZ
 */
class CapsuleDistance{
public:
	//--------------------------------------------------------------------------
	// _
	//--------------------------------------------------------------------------
	/**
	 * _̓
	 * @param capsule JvZ
	 * @param point _
	 * @return ̓
	 */
	static float squaredDistance(const Capsule& capsule, const Vector3& point);

	//--------------------------------------------------------------------------
	// JvZ
	//--------------------------------------------------------------------------
	/**
	 * JvZ̓
	 * @param capsule0 JvZ
	 * @param capsule1 JvZ
	 * @return ̓
	 */
	static float squaredDistance(
		const Capsule& capsule0, const Capsule& capsule1);

	//--------------------------------------------------------------------------
	// R[
	//--------------------------------------------------------------------------
	/**
	 * R[̓
	 * @param capsule JvZ
	 * @param cone R[
	 * @return ̓
	 */
	static float squaredDistance(const Capsule& capsule, const Cone& cone);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C̓
	 * @param capsule JvZ
	 * @param line C
	 * @return ̓
	 */
	static float squaredDistance(const Capsule& capsule, const Line& line);

	//--------------------------------------------------------------------------
	// w{bNX
	//--------------------------------------------------------------------------
	/**
	 * w{bNX̓
	 * @param capsule JvZ
	 * @param ob w{bNX
	 * @return ̓
	 */
	static float squaredDistance(const Capsule& capsule, const OrientedBox& ob);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ʋ
	 * @param capsule JvZ
	 * @param plane 
	 * @return 
	 */
	static float distance(const Capsule& capsule, const Plane& plane);

	//--------------------------------------------------------------------------
	// C
	//--------------------------------------------------------------------------
	/**
	 * C̓
	 * @param capsule JvZ
	 * @param ray C
	 * @return ̓
	 */
	static float squaredDistance(const Capsule& capsule, const Ray& ray);

	//--------------------------------------------------------------------------
	// ZOg
	//--------------------------------------------------------------------------
	/**
	 * ZOg̓
	 * @param capsule JvZ
	 * @param segment ZOg
	 * @return ̓
	 */
	static float squaredDistance(
		const Capsule& capsule, const Segment& segment);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̓
	 * @param capsule JvZ
	 * @param sphere 
	 * @return ̓
	 */
	static float squaredDistance(
		const Capsule& capsule, const Sphere& sphere);

	//--------------------------------------------------------------------------
	// Op
	//--------------------------------------------------------------------------
	/**
	 * Op̓
	 * @param capsule JvZ
	 * @param triangle Op
	 * @return ̓
	 */
	static float squaredDistance(
		const Capsule& capsule, const Triangle& triangle);

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	CapsuleDistance();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CAPSULE_DISTANCE_H_
//------------------------------------------------------------------------------
