//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * PS2pbhJRg[wb_
 * @author Junpee
 */

#ifndef PS2_PAD_CAMERA_CONTROLLER_H_
#define PS2_PAD_CAMERA_CONTROLLER_H_

namespace Lamp{

class Camera;
class Joystick;
class PS2Pad;

//------------------------------------------------------------------------------
/**
 * PS2pbhJRg[
 */
class PS2PadCameraController{
public:
	/**
	 * RXgN^
	 */
	PS2PadCameraController();

	/**
	 * fXgN^
	 */
	virtual ~PS2PadCameraController();

	/**
	 * Rg[
	 */
	virtual void control();

	//--------------------------------------------------------------------------
	/**
	 * J̐ݒ
	 * @param camera ݒ肷J
	 */
	virtual void setCamera(Camera* camera){ camera_ = camera; }

	/**
	 * J̎擾
	 * @return J
	 */
	virtual Camera* getCamera(){ return camera_; }

	//--------------------------------------------------------------------------
	/**
	 * ]x̐ݒ
	 * @param rotationSensibility ]x
	 */
	virtual void setRotationSensibility(float rotationSensibility){
		rotationSensibility_ = rotationSensibility;
	}

	/**
	 * ]x̎擾
	 * @return ]x
	 */
	virtual float getRotationSensibility() const{ return rotationSensibility_; }

	//--------------------------------------------------------------------------
	/**
	 * ړx̐ݒ
	 * @param translationSensibility ړx
	 */
	virtual void setTranslationSensibility(float translationSensibility){
		translationSensibility_ = translationSensibility;
	}

	/**
	 * ړx̎擾
	 * @return ړx
	 */
	virtual float getTranslationSensibility() const{
		return translationSensibility_;
	}

	//--------------------------------------------------------------------------
	/**
	 * px̐ݒ
	 * @param fovYSensibility px
	 */
	virtual void setFovYSensibility(float fovYSensibility){
		fovYSensibility_ = fovYSensibility;
	}

	/**
	 * px̎擾
	 * @return px
	 */
	virtual float getFovYSensibility() const{ return fovYSensibility_; }

	//--------------------------------------------------------------------------
	/**
	 * WCXeBbN̐ݒ
	 * @param joystick ݒ肷PS2݊WCXeBbN
	 * @return true
	 */
	virtual bool setJoystick(Joystick* joystick);

	/**
	 * WCXeBbN̎擾
	 * @return WCXeBbN
	 */
	virtual Joystick* getJoystick();

	/**
	 * WCXeBbŇ
	 * @return WCXeBbNBNULLB
	 */
	virtual Joystick* searchJoystick();

protected:
	//--------------------------------------------------------------------------
	/// J
	Camera* camera_;
	/// pbh
	PS2Pad* pad_;
	/// ]x
	float rotationSensibility_;
	/// ړx
	float translationSensibility_;
	/// px
	float fovYSensibility_;
	/// ړ[h
	bool moveMode_;

private:
	// Rs[RXgN^̉B
	PS2PadCameraController(const PS2PadCameraController& copy);

	// Rs[̉B
	void operator =(const PS2PadCameraController& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of PS2_PAD_CAMERA_CONTROLLER_H_
//------------------------------------------------------------------------------
