//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * l̃JRg[wb_
 * @author Junpee
 */

#ifndef FIRST_PERSON_CAMERA_CONTROLLER_H_
#define FIRST_PERSON_CAMERA_CONTROLLER_H_

namespace Lamp{

class Camera;

//------------------------------------------------------------------------------
/**
 * l̃JRg[
 */
class FirstPersonCameraController{
public:
	/**
	 * RXgN^
	 */
	FirstPersonCameraController();

	/**
	 * fXgN^
	 */
	virtual ~FirstPersonCameraController();

	/**
	 * J̐ݒ
	 * @param camera J
	 */
	virtual void setCamera(Camera* camera){ camera_ = camera; }

	/**
	 * ZbgAbv
	 * @param nearClip jANbv
	 * @param farClip t@[Nbv
	 * @param aspect AXyNg
	 */
	virtual void setup(float nearClip, float farClip, float aspect);

	/**
	 * EBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 */
	virtual LRESULT windowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

	//--------------------------------------------------------------------------
	/**
	 * Jʒu̐ݒ
	 * @param position Jʒu
	 */
	virtual void setCameraPosition(const Vector3& position){
		cameraPosition_ = position;
	}

	/**
	 * Jʒu̎擾
	 * @return Jʒu
	 */
	virtual const Vector3& getCameraPosition() const{ return cameraPosition_; }

	//--------------------------------------------------------------------------
	/**
	 * J]l̐ݒ
	 * @param rotation J]l
	 */
	virtual void setCameraRotation(const Vector3& rotation){
		cameraRotation_ = rotation;
	}

	/**
	 * J]l̎擾
	 * @return J]l
	 */
	virtual const Vector3& getCameraRotation() const{ return cameraRotation_; }

	//--------------------------------------------------------------------------
	/**
	 * @̎擾
	 * @return @
	 */
	virtual String getOperationString() const{
		return String(
			"hbO@J̌ύX\n"
			"EhbO@㉺EɃJړ\n"
			"Shift+EhbO@O㍶EɃJړ\n"
			"[ e ]@JOړ\n[ d ]@Jړ\n"
			"[ f ]@JEړ\n[ s ]@Jړ\n"
			"[ r ] Jړ\n[ v ] Jړ\n"
			"}EXzC[ŃY[CAY[AEg\n"
			"ShiftȂL[͂1/10̑xŃJړ܂\n"
		);
	}

	/**
	 * CtH[V̎擾
	 * @return CtH[V
	 */
	const String& getInformationString() const{ return informationString_; }

private:
	// Rs[RXgN^̉B
	FirstPersonCameraController(const FirstPersonCameraController& copy);

	// Rs[̉B
	void operator =(const FirstPersonCameraController& copy);

	// J
	Camera* camera_;
	// Jړl
	Vector3 cameraPosition_;
	// J]l
	Vector3 cameraRotation_;
	// p
	float fovY_;
	// CtH[V
	String informationString_;

	// ړɊւ}EXx
	float cameraPositionSensibility_;
	// ]Ɋւ}EXx
	float cameraRotationSensibility_;
	// L[{[hx
	float keyboardSensibility_;
	// }EXXʒu
	int mouseXPosition_;
	// }EXYʒu
	int mouseYPosition_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of FIRST_PERSON_CAMERA_CONTROLLER_H_
//------------------------------------------------------------------------------
