//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Vvt[[Nwb_
 * @author Junpee
 */

#ifndef SIMPLE_FRAMEWORK_H_
#define SIMPLE_FRAMEWORK_H_

#include <Framework/Utility/WindowCreator.h>

// ȉ̃t@C͕pɂɎgp̂ł炩߃CN[hĂ
#include <Input/Keyboard/Keyboard.h>
#include <Input/Mouse/Mouse.h>
#include <Core/Utility/Random.h>

namespace Lamp{

class FPSController;

//------------------------------------------------------------------------------
/**
 * Vvt[[N
 *
 * ŒKvȏlߍ񂾏ȃt[[NB{IɃt[[NLamp
 * Ƃ₷邽߁ApӂĂ܂iႦȂR[hʂ̏Ȃd3dappjB
 * ƂAvP[Vgޏꍇ́Ãt[[NQlɂăvO
 * 1珑͂߁A񂾂傫Ă΂悢ł傤B
 * ̏ꍇ͋ۂ̃I[oCh\bht[[N\bhƒu悤
 * ƃvOVvɂȂ܂B
 */
class SimpleFramework{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name AvP[V
	 */
	SimpleFramework(const String& name);

	/**
	 * fXgN^
	 */
	virtual ~SimpleFramework();

	/**
	 * s
	 * @param instance CX^Xnh
	 * @return 0Ԃ
	 */
	virtual int execute(HINSTANCE instance);

protected:
	//--------------------------------------------------------------------------
	// I[o[Ch\bh
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ɐtrueԂ
	 */
	virtual bool initialize(){ return true; }

	/**
	 * n
	 */
	virtual void finalize(){}

	/**
	 * s
	 */
	virtual void run(){}

	/**
	 * _O
	 */
	virtual void renderSetup(){}

	/**
	 * _O
	 */
	virtual void render(){}

	//--------------------------------------------------------------------------
	// t[[N\bh
	//--------------------------------------------------------------------------
	/**
	 * t[[N̏
	 * @param instanceHandle CX^Xnh
	 * @return ɐtrueԂ
	 */
	virtual bool frameworkInitialize(HINSTANCE instanceHandle);

	/**
	 * t[[N̎s
	 * @return sʁBWinMain̕Ԃl
	 */
	virtual int frameworkExecute();

	/**
	 * t[[Ňn
	 */
	virtual void frameworkFinalize();

	//--------------------------------------------------------------------------
	// [v̏
	//--------------------------------------------------------------------------
	/**
	 * C[v
	 */
	virtual void mainLoop();

	/**
	 * t[[Ns
	 */
	virtual void frameworkRun();

	/**
	 * t[[N_O
	 */
	virtual void frameworkRenderSetup();

	/**
	 * t[[Nv[e[V
	 * @return foCXXgĂtrue
	 */
	virtual bool frameworkPresentation();

	/**
	 * t[[N_O
	 */
	virtual void frameworkRender();

	//--------------------------------------------------------------------------
	// EBhEvV[W֘A
	//--------------------------------------------------------------------------
	/**
	 * EBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 * @return bZ[WAȏ̏KvȂ0ȊOԂB
	 */
	virtual LRESULT windowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam){
		return 0;
	}

	/**
	 * t[[NEBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 * @return bZ[WAȏ̏KvȂ0ȊOԂB
	 */
	virtual LRESULT frameworkWindowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

public:
	//--------------------------------------------------------------------------
	/**
	 * o^pEBhEvV[W
	 * @param windowHandle EBhEnh
	 * @param message bZ[W
	 * @param wParam wbZ[Wp[^
	 * @param lParam lbZ[Wp[^
	 */
	static LRESULT CALLBACK registrationWindowProcedure(
		HWND windowHandle, u_int message, WPARAM wParam, LPARAM lParam);

protected:
	//--------------------------------------------------------------------------
	/// O
	String name_;
	/// EBhEnh
	HWND windowHandle_;
	/// EBhE쐬p[^
	WindowCreator::CreateParameter createWindowParameter_;
	/// EBhEŏTCY
	DimensionI minimumWindowSize_;
	/// wiF
	Color4c backGroundColor_;

	/// FPSRg[
	FPSController* fpsController_;
	/// L[{[h
	Keyboard* keyboard_;
	/// }EX
	Mouse* mouse_;
	/// tXN[ŊJn邩
	bool startFullscreen_;

	/// CX^X
	static SimpleFramework* instance_;

private:
	// Rs[RXgN^̉B
	SimpleFramework(const SimpleFramework& copy);

	// Rs[̉B
	void operator =(const SimpleFramework& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SIMPLE_FRAMEWORK_H_
//------------------------------------------------------------------------------

