//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[t[[Nwb_
 * @author Junpee
 */

#ifndef SCENE_FRAMEWORK_H_
#define SCENE_FRAMEWORK_H_

#include <Framework/System/BasicFramework.h>

namespace Lamp{

class Renderer;
class InformationRenderer;
class Scene;
class Camera;
class PS2PadCameraController;
class AnimationManager;
class Animation;
class PS2Pad;

//------------------------------------------------------------------------------
/**
 * V[t[[N
 */
class SceneFramework : public BasicFramework{
public:
	/**
	 * RXgN^
	 *
	 * EBhE񋓂̏s
	 * @param name AvP[V
	 */
	SceneFramework(const String& name);

	/**
	 * fXgN^
	 */
	virtual ~SceneFramework();

	/**
	 * V[̃[h
	 * @param sceneName V[
	 * @return true
	 */
	virtual bool loadScene(const String& sceneName);

protected:
	//--------------------------------------------------------------------------
	/**
	 * t[[N̏
	 * @param instanceHandle CX^Xnh
	 * @return ɐtrueԂ
	 */
	virtual bool frameworkInitialize(HINSTANCE instanceHandle);

	/**
	 * t[[Ňn
	 */
	virtual void frameworkFinalize();

	/**
	 * t[[Ns
	 */
	virtual void frameworkRun();

	/**
	 * t[[N_O
	 */
	virtual void frameworkRenderSetup();

	/**
	 * t[[N_O
	 */
	virtual void frameworkRender();

	//--------------------------------------------------------------------------
	/**
	 * V[̃NA
	 */
	virtual void clearScene();

	//--------------------------------------------------------------------------
	/// _
	Renderer* renderer_;
	/// CtH[V_
	InformationRenderer* informationRenderer_;

	/// V[
	String sceneName_;
	/// V[
	Scene* scene_;
	/// J
	Camera* camera_;
	/// JRg[
	PS2PadCameraController* cameraController_;

	/// Aj[V}l[W
	AnimationManager* animationManager_;
	/// Aj[V
	Animation* animation_;
	/// s
	int runCount_;

	/// pbh
	PS2Pad* pad_;
	
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SCENE_FRAMEWORK_H_
//------------------------------------------------------------------------------

