//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * {t[[Nwb_
 * @author Junpee
 */

#ifndef BASIC_FRAMEWORK_H_
#define BASIC_FRAMEWORK_H_

#include <Framework/System/SimpleFramework.h>

#include <Graphics/System/GraphicsDeviceObjectHolder.h>
#include <Graphics/Enumeration/ConfirmGraphicsDevice.h>
#include <Core/Utility/Timer.h>


namespace Lamp{

class FPSMeasurement;

//------------------------------------------------------------------------------
/**
 * {t[[N
 *
 * Vvt[[NID3DXɂtHg`FPSv
 * OtBbNXfoCXIǉt[[NB
 */
class BasicFramework :
	public SimpleFramework, public GraphicsDeviceObjectHolder,
	public ConfirmGraphicsDevice{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name AvP[V
	 */
	BasicFramework(const String& name);

	/**
	 * fXgN^
	 */
	virtual ~BasicFramework();

	//--------------------------------------------------------------------------
	// I[o[Ch\bh
	//--------------------------------------------------------------------------
	/**
	 * OtBbNXfoCX̊mF
	 *
	 * foCX̔\͂mFāAgpȂtrueAgpȂȂfalseԂB
	 * @param deviceCapability foCX\
	 * @param vertexProcessingType _vZX^Cv
	 * @param adapterFormat A_v^̃tH[}bg
	 * @param backBufferFormat obNobt@̃tH[}bg
	 * @return foCX̎gpȂtrueԂB
	 */
	virtual bool confirmGraphicsDevice(
		const D3DCapacity& deviceCapability, u_int vertexProcessingType,
		D3DFORMAT adapterFormat, D3DFORMAT backBufferFormat){
		// SẴfoCX
		return true;
	}

	//--------------------------------------------------------------------------
	// foCXIuWFNg֘A
	//--------------------------------------------------------------------------
	/**
	 * foCXIuWFNg̏
	 *
	 * foCXIuWFNg̏initializeDeviceObjectsI[oCh
	 * @return trueԂ
	 */
	virtual bool initializeGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̍폜
	 *
	 * foCXIuWFNg̍폜deleteDeviceObjectsI[oCh
	 */
	virtual void deleteGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̃XgA
	 *
	 * foCXIuWFNg̃XgArestoreDeviceObjectsI[oCh
	 * ̃\bhłŃfoCXXe[gύXƁAftHgXe[gƂȂA
	 * _ZbgAbvɂ̃Xe[g܂B
	 * @return trueԂ
	 */
	virtual bool restoreGraphicsDeviceObjects();

	/**
	 * foCXIuWFNg̖
	 *
	 * foCXIuWFNg̖invalidateDeviceObjectsI[oCh
	 */
	virtual void invalidateGraphicsDeviceObjects();

protected:
	//--------------------------------------------------------------------------
	// I[o[Ch\bh
	//--------------------------------------------------------------------------
	/**
	 * C[v
	 */
	virtual void mainLoop();

	/**
	 * `
	 */
	virtual void drawInformation();

	//--------------------------------------------------------------------------
	// [eBeB\bh
	//--------------------------------------------------------------------------
	/**
	 * 񕶎`
	 * @param message `悷郁bZ[W
	 * @param color ̕`F
	 * @param alignRight trueȂEɊ񂹂ĕ`悷
	 * @param alignBottom trueȂ牺Ɋ񂹂ĕ`悷
	 */
	virtual void drawInformationString(const String& message,
		Color4c color = Color4c::white,
		bool alignRight = false, bool alignBottom = false);

	/**
	 * FPS̎擾
	 * @return FPS
	 */
	virtual String getFPSString() const;

	//--------------------------------------------------------------------------
	// t[[N\bh
	//--------------------------------------------------------------------------
	/**
	 * t[[Ns
	 */
	virtual void frameworkRun();

	/**
	 * t[[N\
	 */
	virtual void frameworkDrawInformation();

	//--------------------------------------------------------------------------
	/// ``
	RECT informationDrawRect_;
	/// tHg
	ID3DXFont* font_;
	/// tHgLq
	D3DXFONT_DESC fontDescription_;

	/// `FPSv
	FPSMeasurement* drawFPSMeasurement_;
	/// `FPS
	float drawFPS_;
	/// Q[FPSv
	FPSMeasurement* gameFPSMeasurement_;
	/// Q[FPS
	float gameFPS_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BASIC_FRAMEWORK_H_
//------------------------------------------------------------------------------

