//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ^C}wb_
 * @author Junpee
 */

#ifndef Timer_H_
#define Timer_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ^C}
 *
 * ԊԊuv܂B<br>
 * ^C}gp邽߂ɂ́A܂VXȅ Timer::initialize()
 * ĂłB̌㎞Ԃv̑O Timer::getTick()ĂсA
 * v̌ Timer::getInterval() ĂłB
 * <pre>
 * TvR[h
 * 
 * // 
 * Timer::initialize();
 * // vJnԂ̎擾
 * Timer::Tick startTime = Timer::getTick();
 * // Ԃv鏈
 * targetMethod1();
 * // ԊԊu̎擾
 * float msTime = Timer::getInterval(startTime);
 * // fobOo͂ɕ\
 * DebugOut("targetMethod1() using %fms\n", msTime);
 * </pre>
 */
//------------------------------------------------------------------------------
class Timer{
public:
	/**
	 * Timer::getTick()Ăяo_ł̎
	 *
	 * Timer::getInterval()ɂ莞Ԃ̊Ԋu擾łB
	 * @see Timer
	 */
	class Tick{
		friend class Timer;
	public:
		/**
		 * RXgN^
		 */
		Tick(){ tick = 0; }

		/**
		 * l̎擾
		 * @return tick̉32rbgl
		 */
		u_int getValue(){ return (u_int)(tick & 0xffffffff); }

	private:
		// 
		long long tick;

	};

	/**
	 * ^C}܂
	 *
	 * VXȅɈxĂяoĂB
	 */
	static void initialize();

	/**
	 * Ԃ̎擾
	 * @return getTick()Ă񂾎ԁB
	 * @see Tick
	 */
	static Tick getTick();

	/**
	 * ԊԊu̎擾
	 *
	 * ȑOɎ擾Ԃ̎ԊԊu~bPʂŎ擾܂B
	 * @param previousTick ȑOɎ擾
	 * @return ~bPʂł̎ԊԊu
	 */
	static float getInterval(const Tick& previousTick);

	/**
	 * ԊԊu̎擾
	 *
	 * ȑOɎ擾ԂȌɎ擾Ԃ̎ԊԊu~bPʂŎ擾܂B
	 * @param previousTick ȑOɎ擾
	 * @param afterTick ȌɎ擾
	 * @return ~bPʂł̎ԊԊu
	 */
	static float getInterval(const Tick& previousTick, const Tick& afterTick);

private:
	// 1ms̃NbN
	static float tickPerMillisecond_;
	// ς݃tO
	static bool initialized_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of Timer_H_
//------------------------------------------------------------------------------
