//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XgOg[NiCUwb_
 * @author Junpee
 */

#ifndef STRING_TOKENIZER_H_
#define STRING_TOKENIZER_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * XgOg[NiCU
 */
class StringTokenizer{
public:
	/**
	 * RXgN^
	 *
	 * ̃RXgN^gpꍇAinitialize()\bhĂԕKv܂B
	 */
	explicit StringTokenizer();
	 
	/**
	 * RXgN^
	 * @param target ͂镶
	 */
	explicit StringTokenizer(const String& target){
		initialize(target);
	}

	/**
	 * RXgN^
	 *
	 * ̃RXgN^gpꍇStringTokenizerj܂
	 * ͂f[^ύXȂŉB
	 * @param target ͂f[^
	 */
	explicit StringTokenizer(const char* target){
		initialize(target);
	}

	/**
	 * RXgN^
	 * @param target ͂镶
	 * @param delimiter ؂蕶
	 */
	StringTokenizer(const String& target, const String& delimiter){
		initialize(target, delimiter);
	}

	/**
	 * RXgN^
	 *
	 * ̃RXgN^gpꍇStringTokenizerj܂
	 * ͂f[^ύXȂŉB
	 * @param target ͂f[^
	 * @param delimiter ؂蕶
	 */
	StringTokenizer(const char* target, const String& delimiter){
		initialize(target, delimiter);
	}

	/**
	 * RXgN^
	 * @param target ͂镶
	 * @param delimiter ؂蕶
	 * @param delimiterOutput trueȂ؂蕶g[NƂďo
	 */
	StringTokenizer(const String& target, const String& delimiter,
		bool delimiterOutput){
		initialize(target, delimiter, delimiterOutput);
	}

	/**
	 * RXgN^
	 *
	 * ̃RXgN^gpꍇStringTokenizerj܂
	 * ͂f[^ύXȂŉB
	 * @param target ͂f[^
	 * @param delimiter ؂蕶
	 * @param delimiterOutput trueȂ؂蕶g[NƂďo
	 */
	StringTokenizer(const char* target,
		const String& delimiter, bool delimiterOutput){
		initialize(target, delimiter, delimiterOutput);
	}

	/**
	 * 
	 * @param target ͂镶
	 * @param delimiter ؂蕶
	 * @param delimiterOutput trueȂ؂蕶g[NƂďo
	 */
	void initialize(const char* target,
		const String& delimiter = defaultDelimiter,
		bool delimiterOutput = false);

	/**
	 * 
	 * @param target ͂镶
	 * @param delimiter ؂蕶
	 * @param delimiterOutput trueȂ؂蕶g[NƂďo
	 */
	void initialize(const String& target,
		const String& delimiter = defaultDelimiter,
		bool delimiterOutput = false);

	/**
	 * fXgN^
	 */
	virtual ~StringTokenizer();

	/**
	 * g[N܂邩ǂ
	 * @return trueȂg[NB
	 */
	virtual bool hasMoreTokens();

	/**
	 * ̃g[N擾
	 * @return ̃g[N
	 */
	virtual String getNextToken();

	/**
	 * g[NItZbg̎擾
	 * @return g[NItZbg
	 */
	virtual int getTokenOffset() const{ return tokenOffset_; }

	/**
	 * ݂̃g[N擾
	 * @return ݂̃g[N
	 */
	virtual String getNowToken() const{ return nowToken_; }

	/**
	 * Õg[N擾
	 * @return Õg[N
	 */
	virtual String getPreviousToken() const{ return previousToken_; }

private:

	// Rs[RXgN^̉B
	StringTokenizer(const StringTokenizer& copy);

	// Rs[̉B
	void operator =(const StringTokenizer& copy);

	// ΏەBf[^̊mۂړIB
	String targetString_;
	// x[X|C^
	const char* base_;
	// Jg|C^
	const char* current_;
	// g[NItZbg
	int tokenOffset_;
	// f~^
	String delimiter_;
	// ݂̃g[N
	String nowToken_;
	// Õg[N
	String previousToken_;
	// f~^o̓tO
	bool delimiterOutput_;

	// ftHgf~^
	static const String defaultDelimiter;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STRING_TOKENIZER_H_
//------------------------------------------------------------------------------
