//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * _wb_
 * @author Junpee
 */

#ifndef RANDOM_H_
#define RANDOM_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * _
 *
 * ̃NX͌pȂŉB
 */
class Random{
public:
	/**
	 * RXgN^
	 * @param initialSeed 
	 */
	explicit Random(u_int initialSeed = 1){ setSeed(initialSeed); }

	/**
	 * ̐ݒ
	 * @param seed ݒ肷
	 */
	void setSeed(u_int seed){ seed_ = seed; }

	/**
	 * _l̎擾
	 * @return 0ȏARandom::maxȉ̃_lB
	 */
	inline u_int get(){
		seed_ = 1664525 * seed_ + 1013904223;
		return seed_;
	}

	/**
	 * byte_l̎擾
	 * @return 0ȏA255ȉ̃_l
	 */
	inline int getByte(){
		return (get() & 0xff);
	}

	/**
	 * float_l̎擾
	 * @return -1.fȏA1.f̃_lԂ
	 */
	inline float getSignedFloat(){
		float result;
		(*(u_int*)&result) = 0x3f800000 | (0x7fffff & get());
		return (result * 2.f) - 3.f;
	}

	/**
	 * unsigned float_l̎擾
	 * @return 0.fȏA1.f̃_lԂ
	 */
	inline float getUnsignedFloat(){
		float result;
		(*(u_int*)&result) = 0x3f800000 | (0x7fffff & get());
		return result - 1.0f;
	}

private:
	// Rs[RXgN^̉B
	Random(const Random& copy);

	// Rs[̉B
	void operator =(const Random& copy);

	// _̎
	u_int seed_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RANDOM_H_
//------------------------------------------------------------------------------
