//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * FPSvwb_
 * @author Junpee
 */

#ifndef FPS_MEASUREMENT_H_
#define FPS_MEASUREMENT_H_

#include <Core/Utility/Timer.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * FPSv
 */
class FPSMeasurement{
public:
	/**
	 * RXgN^
	 */
	FPSMeasurement();

	/**
	 * fXgN^
	 */
	virtual ~FPSMeasurement();

	/**
	 * Zbg
	 */
	virtual void reset();

	/**
	 * v
	 * @return FPS
	 */
	virtual float measurement();

	/**
	 * FPS̎擾
	 * @return FPS
	 */
	virtual float getFPS(){ return fps_; }

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	FPSMeasurement(const FPSMeasurement& copy);

	// Rs[̉B
	void operator =(const FPSMeasurement& copy);

	// FPS
	float fps_;
	// O^C
	Timer::Tick lastTime_;
	// t[
	int frameCount_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of FPS_MEASUREMENT_H_
//------------------------------------------------------------------------------

