//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * FPSRg[wb_
 * @author Junpee
 */

#ifndef FPS_CONTROLLER_H_
#define FPS_CONTROLLER_H_

#include <Core/Utility/Timer.h>
#include <Core/Thread/CriticalSection.h>
#include <Core/Container/Deque.h>

namespace Lamp{

class Thread;

//------------------------------------------------------------------------------
/**
 * FPSRg[
 */
class FPSController{
public:
	/// 60FPS
	static const float interval60FPS;
	/// 30FPS
	static const float interval30FPS;

	/**
	 * RXgN^
	 * @param targetInterval ڕWԊԊu~bŎw
	 */
	FPSController(float targetInterval = interval60FPS);

	/**
	 * fXgN^
	 */
	virtual ~FPSController();

	//--------------------------------------------------------------------------
	/**
	 * ڕWԊԊu̐ݒ
	 * @param targetInterval ڕWԊԊu~bŎw
	 */
	virtual void setTargetInterval(float targetInterval){
		targetInterval_ = targetInterval;
		sleepTime_ = targetInterval_;
		intervalTime_ = targetInterval_;
	}

	/**
	 * ڕWԊԊu̎擾
	 * @return ڕWԊԊu~bŕԂ
	 */
	virtual float getTargetInterval() const{ return targetInterval_; }

	/**
	 * FPSێ邽߂ɃJgXbhsleep
	 * @return OsleepƂ̎ԊԊu
	 */
	virtual float sleep();

	/**
	 * C^[o̎擾
	 * @return C^[o~bŎ擾
	 */
	virtual float getIntervalTime() const{ return intervalTime_; }

	/**
	 * X[vԂ̎擾
	 * @return X[vԂ~bŎ擾
	 */
	virtual float getSleepTime() const{ return sleepTime_; }

	/**
	 * Ԃ̎擾
	 * @return Ԃ~bŎ擾
	 */
	virtual float getProcessingTime() const{
		return intervalTime_ - sleepTime_;
	}

	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getProcessingRate() const{
		return getProcessingTime() / getIntervalTime();
	}

	//--------------------------------------------------------------------------
	/**
	 * obNOEhXbh̓o^
	 * @param backgroundThread obNOEhXbh
	 */
	virtual void registerBackgroundThread(Thread* backgroundThread);

	/**
	 * obNOEhXbh̎擾
	 * @return obNOEhXbh
	 */
	virtual int getBackgroundThreadCount();

	/**
	 * obNOEhXbh̎擾
	 * @param index CfbNX
	 * @return obNOEhXbh
	 */
	virtual Thread* getBackgroundThread(int index);

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	virtual String toString() const;

private:
	// Rs[RXgN^̉B
	FPSController(const FPSController& copy);

	// Rs[̉B
	void operator =(const FPSController& copy);

	// obNOEhXbh
	Deque<Thread*> backgroundThreads_;
	// NeBJZNV
	CriticalSection criticalSection_;
	// 
	Timer::Tick tick_;
	// Ԋu
	float intervalTime_;
	// ^[QbgԊu
	float targetInterval_;
	// sleep
	float sleepTime_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of FPS_CONTROLLER_H_
//------------------------------------------------------------------------------

