//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RtBO[Vt@Cwb_
 * @author Junpee
 */

#ifndef CONFIGURATION_FILE_H_
#define CONFIGURATION_FILE_H_

#include <Core/Container/HashMap.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * RtBO[Vt@C
 */
class ConfigurationFile{
public:
	/**
	 * RXgN^
	 * @param fileName [hRtBOt@C
	 */
	explicit ConfigurationFile(const String& fileName);

	/**
	 * fXgN^
	 */
	virtual ~ConfigurationFile();

	/**
	 * f[^̎擾
	 */
	virtual int getCount() const{ return database_.getCount(); }

	/**
	 * charf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] charꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getChar(const String& key, char* value) const;

	/**
	 * u_charf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] u_charꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getUChar(const String& key, u_char* value) const;

	/**
	 * shortf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] shortꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getShort(const String& key, short* value) const;

	/**
	 * u_shortf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] u_shortꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getUShort(const String& key, u_short* value) const;

	/**
	 * intf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] intꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getInt(const String& key, int* value) const;

	/**
	 * u_intf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] u_intꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getUInt(const String& key, u_int* value) const;

	/**
	 * floatf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] floatꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getFloat(const String& key, float* value) const;

	/**
	 * doublef[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] doubleꂽl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getDouble(const String& key, double* value) const;

	/**
	 * Stringf[^̎擾
	 * @param key 擾f[^̃L[
	 * @param value [out] Stringl܂
	 * @return trueȂf[^̎擾ɐ
	 */
	virtual bool getString(const String& key, String* value) const;

private:
	/**
	 * [h
	 * @param fileName [hRtBOt@C
	 */
	virtual void load(const String& fileName);

	/**
	 * f[^̒ǉ
	 * @param key ǉf[^̃L[
	 * @param value ǉf[^
	 */
	virtual void add(const String& key, const String& value);

	// Rs[RXgN^̉B
	ConfigurationFile(const ConfigurationFile& copy);

	// Rs[̉B
	void operator =(const ConfigurationFile& copy);

	// t@C
	String fileName_;
	// f[^x[X
	HashMap<String, String> database_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of CONFIGURATION_FILE_H_
//------------------------------------------------------------------------------
