//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * EFCgZbgwb_
 * @author Junpee
 */

#ifndef WAIT_SET_H_
#define WAIT_SET_H_

#include <Core/Thread/LockObject.h>
#include <Core/Container/Deque.h>

namespace Lamp{

class Thread;

//------------------------------------------------------------------------------
/**
 * EFCgZbg
 */
class WaitSet : public LockObject{
public:
	/**
	 * RXgN^
	 *
	 * NeBJZNVɂ铯s
	 */
	WaitSet();

	/**
	 * RXgN^
	 * @param lockObject bNIuWFNg
	 * @param deleteLockObject bNIuWFNgWaitSet폜Ȃtrue
	 */
	WaitSet(LockObject* lockObject, bool deleteLockObject);

	/**
	 * fXgN^
	 */
	virtual ~WaitSet();

	//--------------------------------------------------------------------------
	/**
	 * ҋ@
	 * @param thread ҋ@Xbh
	 *
	 * ̃Xbhҋ@܂BĂяoɂWaitSetɑ΂郍bNKvB
	 * JgXbhł荂ɓ삵܂B
	 */
	virtual void wait(const Thread* thread);

	/**
	 * ҋ@
	 * JgXbhҋ@܂BĂяoɂWaitSetɑ΂郍bNKvB
	 */
	virtual void wait();

	/**
	 * ҋ@
	 *
	 * ̃Xbh̑ҋ@܂BĂяoɂWaitSetɑ΂郍bNKvB
	 */
	virtual void notify();

	/**
	 * ҋ@S
	 *
	 * SẴXbh̑ҋ@܂BĂяoɂWaitSetɑ΂郍bNKvB
	 */
	virtual void notifyAll();

	//--------------------------------------------------------------------------
	/**
	 * bN
	 */
	virtual void lock(){ lockObject_->lock(); }

	/**
	 * AbN
	 */
	virtual void unlock(){ lockObject_->unlock(); }

	/**
	 * JgXbhɂăbNĂ邩
	 * @return JgXbhɂăbNĂtrue
	 */
	virtual bool isLockedByCurrentThread() const{
		return lockObject_->isLockedByCurrentThread();
	}

private:
	// Xbhz
	Deque<HANDLE> waitingThreads_;
	// bNIuWFNg
	LockObject* lockObject_;
	// bNIuWFNg폜tO
	bool deleteLockObject_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of WAIT_SET_H_
//------------------------------------------------------------------------------

