//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Xbhwb_
 * @author Junpee
 */

#ifndef THREAD_H_
#define THREAD_H_

#include <Core/Thread/Runnable.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * Xbh
 *
 * Xbh̓}`XbhłC^CCuKvƂ܂BrhłȂ
 * ꍇ̓^CCu̐ݒ肪}`XbhɂȂĂ邩mFĂB
 */
class Thread : public Runnable{
friend class LampCore;
public:
	/// Dx
	enum Priority{
		/// ^CNeBJ
		priorityTimeCritical =	THREAD_PRIORITY_TIME_CRITICAL,
		/// ƂĂ
		priorityHighest =		THREAD_PRIORITY_HIGHEST,
		/// 
		priorityHigh =			THREAD_PRIORITY_ABOVE_NORMAL,
		/// ʏ
		priorityNormal =		THREAD_PRIORITY_NORMAL,
		/// Ⴂ
		priorityLow =			THREAD_PRIORITY_BELOW_NORMAL,
		/// ƂĂႢ
		priorityLowest =		THREAD_PRIORITY_LOWEST,
		/// ACh
		priorityIdle =			THREAD_PRIORITY_IDLE,
	};

	//--------------------------------------------------------------------------
	// AI
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	Thread();

	/**
	 * RXgN^
	 * @param runnable sΏ
	 */
	Thread(Runnable* runnable);

	/**
	 * RXgN^
	 * @param lockObject bNIuWFNg
	 * @param deleteLockObject bNIuWFNgThread폜Ȃtrue
	 */
	Thread(LockObject* lockObject, bool deleteLockObject);

	/**
	 * RXgN^
	 * @param runnable sΏ
	 * @param lockObject bNIuWFNg
	 * @param deleteLockObject bNIuWFNgThread폜Ȃtrue
	 */
	Thread(Runnable* runnable, LockObject* lockObject, bool deleteLockObject);

	/**
	 * fXgN^
	 */
	virtual ~Thread();

	//--------------------------------------------------------------------------
	// Xbh̑
	//--------------------------------------------------------------------------
	/**
	 * XbhJn
	 */
	virtual void start();

	/**
	 * XbhZbgAbv
	 */
	virtual void setup();

	/**
	 * s
	 * @param thread sĂXbh
	 *
	 * isStopRequested()trueԂꍇ͑₩ɏI
	 */
	virtual void run(Thread* thread){}

	/**
	 * Xbh̏I˗
	 */
	virtual void requestStop();

	/**
	 * Xbh̏I˗AI҂
	 */
	virtual void stop(){ stop(INFINITE); }

	/**
	 * Xbh̏I˗AI҂
	 * @param milliseconds ^CAEg܂ł̃~bw肷
	 * @return IĂtrueԂAfalseȂ^CAEg
	 */
	virtual bool stop(u_int milliseconds);

	/**
	 * Xbh̏I҂
	 */
	virtual void join(){ join(INFINITE); }

	/**
	 * Xbh̏I҂
	 * @param milliseconds ^CAEg܂ł̃~bw肷
	 * @return IĂtrueԂAfalseȂ^CAEg
	 */
	virtual bool join(u_int milliseconds);

	//--------------------------------------------------------------------------
	/**
	 * vCIeB̐ݒ
	 */
	virtual void setPriority(Priority priority);

	/**
	 * vCIeB̎擾
	 */
	virtual Priority getPriority();

	//--------------------------------------------------------------------------
	/**
	 * TXyh
	 *
	 * bN̂Ŏgsuspend͌ĂׂȂ
	 */
	virtual void suspend();

	/**
	 * W[
	 */
	virtual void resume();

	//--------------------------------------------------------------------------
	// oANZT
	//--------------------------------------------------------------------------
	/**
	 * Xbhnh̎擾
	 * @return Xbhnh
	 */
	virtual HANDLE getThreadHandle() const{ return threadHandle_; }

	/**
	 * XbhID̎擾
	 * @return XbhID
	 */
	virtual u_int getThreadID() const{ return threadID_; }

	/**
	 * XbhIĂ邩
	 * @return XbhIĂtrue
	 */
	virtual bool isFinished() const{ return isFinished_; }

	/**
	 * X^bNTCY̎擾
	 * @return X^bNTCY
	 *
	 * ̃\bhI[o[Ch邱ƂɂX^bNTCYύXł܂
	 */
	virtual u_int getStackSize(){ return 1024 * 1024; }

	//--------------------------------------------------------------------------
	// ÓI֐
	//--------------------------------------------------------------------------
	/**
	 * JgXbh̋x~
	 * @param milliseconds x~Ԃ~bŎw肷
	 */
	static void sleep(u_int milliseconds){ ::Sleep(milliseconds); }

	/**
	 * JgXbh琧
	 */
	static void yield(){ ::Sleep(0); }

	//--------------------------------------------------------------------------
	// gps
	//--------------------------------------------------------------------------
	/**
	 * Xbh̎sbp
	 *
	 * ̃\bh̓VXe痘p̂ŌČĂяoȂŉ
	 */
	virtual u_int executeWrapper();

	//--------------------------------------------------------------------------
protected:
	/**
	 * Xbh̍쐬
	 */
	virtual void createThread();

private:
	/**
	 * 
	 */
	static void initialize();

	/**
	 * n
	 */
	static void finalize();

	// sΏ
	Runnable* runnable_;
	// Xbhnh
	HANDLE threadHandle_;
	// XbhID
	u_int threadID_;
	// XbhIĂ邩
	volatile bool isFinished_;

	// sȃXbhnh
	static const HANDLE invalidThreadHandle;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of THREAD_H_
//------------------------------------------------------------------------------
