//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ubNwb_
 * @author Junpee
 */

#ifndef SYNCHRONIZED_BLOCK_H_
#define SYNCHRONIZED_BLOCK_H_

#include <Core/Thread/LockObject.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ubN
 */
class SynchronizedBlock{
public:
	/**
	 * RXgN^
	 * @param lockObject bNIuWFNg
	 */
	SynchronizedBlock(LockObject& lockObject) : lockObject_(lockObject){
		lockObject_.lock();
	}

	/**
	 * RXgN^
	 * @param lockObject bNIuWFNg
	 */
	SynchronizedBlock(LockObject* lockObject) : lockObject_(*lockObject){
		lockObject_.lock();
	}

	/**
	 * fXgN^
	 */
	virtual ~SynchronizedBlock(){ lockObject_.unlock(); }

protected:
	/// bNIuWFNg
	LockObject& lockObject_;

private:
	// Rs[RXgN^̉B
	SynchronizedBlock(const SynchronizedBlock& copy);

	// Rs[̉B
	void operator =(const SynchronizedBlock& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of SYNCHRONIZED_BLOCK_H_
//------------------------------------------------------------------------------
