//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * s\wb_
 * @author Junpee
 */

#ifndef RUNNABLE_H_
#define RUNNABLE_H_

#include <Core/Thread/WaitSet.h>

namespace Lamp{

class Thread;

//------------------------------------------------------------------------------
/**
 * s\
 */
class Runnable : public WaitSet{
friend class Thread;
public:
	/**
	 * RXgN^
	 */
	Runnable() : WaitSet(), stopRequested_(false){}

	/**
	 * RXgN^
	 * @param lockObject bNIuWFNg
	 * @param deleteLockObject bNIuWFNgWaitSet폜Ȃtrue
	 */
	Runnable(LockObject* lockObject, bool deleteLockObject) :
		WaitSet(lockObject, deleteLockObject), stopRequested_(false){}

	/**
	 * fXgN^
	 */
	virtual ~Runnable(){}

	/**
	 * ~vĂ邩
	 * @return ~vĂtrue
	 */
	bool isStopRequested() const{ return stopRequested_; }

	/**
	 * s
	 * @param thread sĂXbh
	 *
	 * isStopRequested()trueԂꍇ͑₩ɏI
	 */
	virtual void run(Thread* thread) = 0;

private:
	// ~vtO̐ݒ
	void setStopRequested(bool stopRequested){
		stopRequested_ = stopRequested;
	}

	// ~v
	volatile bool stopRequested_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RUNNABLE_H_
//------------------------------------------------------------------------------
