//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 3Dwwb_
 * @author Junpee
 */

#ifndef MATH_3D_H_
#define MATH_3D_H_

#include <Core/Primitive/Vector3.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * 3Dwwb_
 */
class Math3D{
public:

	/**
	 * @̌vZ
	 * @param vertex0 _0
	 * @param vertex1 _1
	 * @param vertex2 _2
	 * @return @
	 */
	static Vector3 calculateNormal(const Vector3& vertex0,
		const Vector3& vertex1, const Vector3& vertex2);

	/**
	 * ZbNAbg
	 * @param target ZڕW
	 * @return XYZ]
	 */
	static Vector3 lookAtZ(const Vector3& target);

private:
	// RXgN^̉B
	Math3D();

};
//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MATH_3D_H_
//------------------------------------------------------------------------------
