//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * wwb_
 * @author Junpee
 */

#ifndef MATH_H_
#define MATH_H_

#include <cmath>
#include <cfloat>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * wwb_
 */
class Math{
public:
	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// pC
	static const float PI;

	/// pC * 4
	static const float quadruplePI;

	/// pC * 2
	static const float doublePI;

	/// pC / 2
	static const float halfPI;

	/// pC / 4
	static const float quadrantPI;

	/// Rΐ̒
	static const float E;

	/// CvV
	static const float epsilon;

	//--------------------------------------------------------------------------
	// Pʕϊ
	//--------------------------------------------------------------------------
	/**
	 * x烉WAւ̕ϊ
	 * @param degree x
	 * @return WA
	 */
	static inline float toRadian(float degree){
		static const float scale = PI / 180.f;
		return degree * scale;
	}

	/**
	 * WAxւ̕ϊ
	 * @param radian WA
	 * @return x
	 */
	static inline float toDegree(float radian){
		static const float scale = 180.f / PI;
		return radian * scale;
	}

	//--------------------------------------------------------------------------
	// Maximum, Minimum
	//--------------------------------------------------------------------------
	/**
	 * Maximum
	 * @param a Ӓl
	 * @param b EӒl
	 * @return 傫ق̒lԂ
	 */
	static inline int maximum(int a, int b){
		if(a > b){ return a; }
		else{ return b; }
	}

	/**
	 * Maximum
	 * @param a Ӓl
	 * @param b EӒl
	 * @return 傫ق̒lԂ
	 */
	static inline u_int maximum(u_int a, u_int b){
		if(a > b){ return a; }
		else{ return b; }
	}

	/**
	 * Maximum
	 * @param a Ӓl
	 * @param b EӒl
	 * @return 傫ق̒lԂ
	 */
	static inline float maximum(float a, float b){
		if(a > b){ return a; }
		else{ return b; }
	}

	/**
	 * Minimum
	 * @param a Ӓl
	 * @param b EӒl
	 * @return ق̒lԂ
	 */
	static inline int minimum(int a, int b){
		if(a < b){ return a; }
		else{ return b; }
	}

	/**
	 * Minimum
	 * @param a Ӓl
	 * @param b EӒl
	 * @return ق̒lԂ
	 */
	static inline int minimum(u_int a, u_int b){
		if(a < b){ return a; }
		else{ return b; }
	}

	/**
	 * Minimum
	 * @param a Ӓl
	 * @param b EӒl
	 * @return ق̒lԂ
	 */
	static inline float minimum(float a, float b){
		if(a < b){ return a; }
		else{ return b; }
	}

	//--------------------------------------------------------------------------
	// Xbv
	//--------------------------------------------------------------------------
	/**
	 * Xbv
	 * @param a Ӓl
	 * @param b EӒl
	 */
	static inline void swap(int& a, int& b){
		int tmp = a;
		a = b;
		b = tmp;
	}

	/**
	 * Xbv
	 * @param a Ӓl
	 * @param b EӒl
	 */
	static inline void swap(u_int& a, u_int& b){
		u_int tmp = a;
		a = b;
		b = tmp;
	}

	/**
	 * Xbv
	 * @param a Ӓl
	 * @param b EӒl
	 */
	static inline void swap(float& a, float& b){
		float tmp = a;
		a = b;
		b = tmp;
	}

	//--------------------------------------------------------------------------
	// Βl
	//--------------------------------------------------------------------------
	/**
	 * Βl
	 * @param x Βlɂ鐔
	 * @return Βl
	 */
	static inline int abs(int x){ return ::abs(x); }

	/**
	 * Βl
	 * @param x Βlɂ鐔
	 * @return Βl
	 */
	static inline float abs(float x){ return ::fabsf(x); }

	//--------------------------------------------------------------------------
	// ؂̂āA؂グ
	//--------------------------------------------------------------------------
	/**
	 * ̐؂̂
	 * @param x ؂̂Ăl
	 * @return ؂̂Ăꂽl
	 */
	static inline float floor(float x){ return ::floorf(x); }

	/**
	 * ̐؂グ
	 * @param x ؂グl
	 * @return ؂グꂽl
	 */
	static inline float ceil(float x){ return ::ceilf(x); }

	//--------------------------------------------------------------------------
	// lZ
	//--------------------------------------------------------------------------
	/**
	 * ]
	 * @param x 
	 * @param y q
	 * @return xyŊۂ̗]Ԃ܂
	 */
	static inline float fmod(float x, float y){ return ::fmodf(x, y); }

	/**
	 * Əւ̕
	 * @param x ΏۂƂȂ镂l
	 * @param integer [out] x̐i[|C^
	 * @return x̏
	 */
	static inline float modf(float x, float* integer){
		return ::modff(x, integer);
	}

	/**
	 * 
	 * @param x Ƃ鐳̒l
	 * @return 
	 */
	static inline float sqrt(float x){
		Assert(x >= 0.f);
		return ::sqrtf(x);
	}

	/**
	 * _`FbN
	 * @param x `FbNl
	 * @return ȒlȂtrue
	 */
	static inline bool classCheck(float x){
		int result = ::_fpclass(x);
		if((result == _FPCLASS_SNAN) ||		// VOi^
			(result == _FPCLASS_QNAN) ||	// NCGbg^
			(result == _FPCLASS_PINF) ||	// ̖
			(result == _FPCLASS_NINF)){		// ̖
			return false;
		}
		return true;
	}

	//--------------------------------------------------------------------------
	// wAΐ
	//--------------------------------------------------------------------------
	/**
	 * ׂ
	 * @param x 
	 * @param y w
	 * @return xyԂ܂
	 */
	static inline float pow(float x, float y){ return ::powf(x, y); }

	/**
	 * w
	 * @param x 搔
	 * @return Rΐ̒ Math::E x̒lԂ܂
	 */
	static inline float exp(float x){ return ::expf(x); }

	/**
	 * Rΐ
	 * @param x RΐƂΏےl
	 * @return x̎RΐԂ܂
	 */
	static inline float log(float x){ return ::logf(x); }

	/**
	 * pΐ
	 * @param x pΐƂΏےl
	 * @return x̏pΐԂ܂
	 */
	static inline float log10(float x){ return ::log10f(x); }

	/**
	 * 2̗ݏ悩ǂ
	 * @return 2̗ݏȂtrue
	 */
	static inline bool checkPow2(int value){
		while(true){
			if(value == 1){ return true; }
			if((value % 2) == 1){ return false; }
			value /= 2;
		}
	}

	//--------------------------------------------------------------------------
	// Op֐
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param x vZl
	 * @return x̐
	 */
	static inline float sin(float x){ return ::sinf(x); }

	/**
	 * ]
	 * @param x ]vZl
	 * @return x̗]
	 */
	static inline float cos(float x){ return ::cosf(x); }

	/**
	 * 
	 * @param x ڂvZl
	 * @return x̐
	 */
	static inline float tan(float x){ return ::tanf(x); }

	/**
	 * oȐ
	 * @param x oȐvZl
	 * @return x̑oȐ
	 */
	static inline float sinh(float x){ return ::sinhf(x); }

	/**
	 * oȗ]
	 * @param x oȗ]vZl
	 * @return x̑oȗ]
	 */
	static inline float cosh(float x){ return ::coshf(x); }

	/**
	 * oȐ
	 * @param x oȐڂvZl
	 * @return x̑oȐ
	 */
	static inline float tanh(float x){ return ::tanhf(x); }

	/**
	 * t
	 * @param x tvZlB-1 ` 1
	 * @return x̋tB-/2 ` /2
	 */
	static inline float asin(float x){ return ::asinf(x); }

	/**
	 * t]
	 * @param x t]vZlB-1 ` 1
	 * @return x̋t]B-/2 ` /2
	 */
	static inline float acos(float x){ return ::acosf(x); }

	/**
	 * t
	 * @param x tڂvZl
	 * @return x̋tځB-/2 ` /2
	 */
	static inline float atan(float x){ return ::atanf(x); }

	/**
	 * t
	 * @param y tڂvZyl
	 * @param x tڂvZxl
	 * @return (x, y)̋tځB- ` 
	 */
	static inline float atan2(float y, float x){ return ::atan2f(y, x); }


private:
	// RXgN^̉B
	Math();

};
//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MATH_H_
//------------------------------------------------------------------------------
