//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Elwb_
 * @author Junpee
 */

#ifndef LIMIT_H_
#define LIMIT_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * El
 */
class Limit{
public:
	/// charŏl
	static const char charMin = (-128);
	/// charől
	static const char charMax = (127);
	/// u_charŏl
	static const u_char uCharMin = (0);
	/// u_charől
	static const u_char uCharMax = (0xff);

	/// shortŏl
	static const short shortMin = (-32768);
	/// shortől
	static const short shortMax = (32767);
	/// u_shortŏl
	static const u_short uShortMin = (0);
	/// u_shortől
	static const u_short uShortMax = (0xffff);

	/// intŏl
	static const int intMin = (-2147483647 - 1);
	/// intől
	static const int intMax = (2147483647);
	/// u_intŏl
	static const u_int uIntMin = (0);
	/// u_intől
	static const u_int uIntMax = (0xffffffff);

	/// floatŏ̐
	static const float floatPositiveMin;
	/// floatől
	static const float floatMax;
	/// floatől
	static const float floatMaxSqrt;

	/// doubleŏl
	static const double doubleMin;
	/// doubleől
	static const double doubleMax;

	//--------------------------------------------------------------------------
	/**
	 * char͈͓̔
	 * @param value `FbNl
	 */
	static bool inCharRange(int value){
		return ((value >= charMin) && (value <= charMax));
	}

	/**
	 * u_char͈͓̔
	 * @param value `FbNl
	 */
	static bool inUCharRange(int value){
		return ((value >= uCharMin) && (value <= uCharMax));
	}

	//--------------------------------------------------------------------------
	/**
	 * short͈͓̔
	 * @param value `FbNl
	 */
	static bool inShortRange(int value){
		return ((value >= shortMin) && (value <= shortMax));
	}

	/**
	 * u_short͈͓̔
	 * @param value `FbNl
	 */
	static bool inUShortRange(int value){
		return ((value >= uShortMin) && (value <= uShortMax));
	}

private:
	//--------------------------------------------------------------------------
	// RXgN^̉B
	Limit();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of _H_
//------------------------------------------------------------------------------
