//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * DirectX`wb_
 * @author Junpee
 */

#ifndef DIRECT_X_DEFINITION_H_
#define DIRECT_X_DEFINITION_H_

/// EBhEYwb_BWinNT4.0AWin98ȍ~
#define _WIN32_WINNT 0x400
#include <Windows.h>

#ifdef _DEBUG
/// fobODirectGraphics̃fobOo͂
#define D3D_DEBUG_INFO
#endif// End of _DEBUG

// DirectGraphics
#include <d3d9.h>

// DirectGraphicsGNXeV
#include <d3dx9.h>

/// DirectInputo[W8
#define DIRECTINPUT_VERSION 0x800
#include <dinput.h>

// DirectSound
#include <dsound.h>

//------------------------------------------------------------------------------
// DirectXp}N
//------------------------------------------------------------------------------
/**
 * DirectX̐
 *
 * [Xɂs܂
 * @param dxStatus DirectX̃Xe[^XBĂtrueԂ
 */
#define DirectXSucceeded(dxStatus) ((dxStatus) >= 0)

/**
 * DirectX̎s
 *
 * [Xɂs܂
 * @param dxStatus DirectX̃Xe[^XBsĂtrueԂ
 */
#define DirectXFailed(dxStatus) ((dxStatus) < 0)

//------------------------------------------------------------------------------
// fobO
#ifdef _DEBUG
/**
 * DirectX̃AT[g
 *
 * [Xɂ͎s܂
 * @param expression sƃAT[g܂
 */
#define DirectXAssert(expression) \
	if(DirectXFailed(expression)){\
		DebugOut("DirectXAssert %s %d\n", __FILE__, __LINE__);\
		_asm{ int 3 }\
	}

/**
 * DirectX̃bZ[WtAT[g
 *
 * [Xɂ͎s܂
 * @param expression sƃAT[g܂
 * @param message AT[gɏo͂郁bZ[W
 */
#define DirectXAssertMessage(expression, message) \
	if(DirectXFailed(expression)){\
		DebugOut("DirectXAssert %s\n%s %d\n", message, __FILE__, __LINE__);\
		_asm{ int 3 }\
	}

/**
 * DirectX̃`FbN
 *
 * [XɃ`FbN͎s܂񂪁A̍\͎s܂
 * @param expression sƃAT[g܂
 */
#define DirectXCheck(expression) DirectXAssert(expression)

/**
 * DirectX̃bZ[Wt`FbN
 *
 * [XɃ`FbN͎s܂񂪁A̍\͎s܂
 * @param expression sƃAT[g܂
 * @param message AT[gɏo͂郁bZ[W
 */
#define DirectXCheckMessage(expression, message) \
	DirectXAssertMessage(expression, message)

//------------------------------------------------------------------------------
// fobO
#else // _DEBUG

/// AT[g_~[
#define DirectXAssert(expression)

/// bZ[WtAT[g_~[
#define DirectXAssertMessage(expression, message)

/// DirectX̃`FbN_~[
#define DirectXCheck(expression) (expression)

/// DirectX̃bZ[Wt`FbN_~[
#define DirectXCheckMessage(expression, message) (expression)

#endif// End of _DEBUG

//------------------------------------------------------------------------------
// o[Wio[C^[tF[X̒`
//------------------------------------------------------------------------------

// DirectGraphics

/// Direct3D
typedef IDirect3D9 Direct3D;

/// Direct3DDevice
typedef IDirect3DDevice9 Direct3DDevice;

/// Direct3DStateBlock
typedef IDirect3DStateBlock9 Direct3DStateBlock;

/// Direct3DSurface
typedef IDirect3DSurface9 Direct3DSurface;

/// Direct3DIndexBuffer
typedef IDirect3DIndexBuffer9 Direct3DIndexBuffer;

/// Direct3DVertexDeclaration
typedef IDirect3DVertexDeclaration9 Direct3DVertexDeclaration;

/// Direct3DVertexBuffer
typedef IDirect3DVertexBuffer9 Direct3DVertexBuffer;

/// Direct3DIndexBuffer
typedef IDirect3DIndexBuffer9 Direct3DIndexBuffer;

/// Direct3DTexture
typedef IDirect3DTexture9 Direct3DTexture;

// DirectGraphicsExtension

/// Direct3DXBuffer
typedef ID3DXBuffer Direct3DXBuffer;

/// Direct3DXMesh
typedef ID3DXMesh Direct3DXMesh;

// DirectInput

/// DirectInput
typedef IDirectInput8 DirectInput;

/// DirectInputDevice
typedef IDirectInputDevice8 DirectInputDevice;

// DirectSound

/// DirectSound
typedef IDirectSound8 DirectSound;

/// DirectSoundPrimaryBuffer
typedef IDirectSoundBuffer DirectSoundPrimaryBuffer;

/// DirectSoundBuffer
typedef IDirectSoundBuffer8 DirectSoundBuffer;

/// DirectSoundNotify
typedef IDirectSoundNotify8 DirectSoundNotify;

/// DirectSound3DBuffer
typedef IDirectSound3DBuffer8 DirectSound3DBuffer;

/// DirectSound3DBuffer
typedef IDirectSound3DListener8 DirectSound3DListener;

//------------------------------------------------------------------------------
// o[Wio[\̂̒`
//------------------------------------------------------------------------------

// DirectGraphics

/// D3DADAPTER_IDENTIFIER
typedef D3DADAPTER_IDENTIFIER9 D3DAdapterIdentifier;

/// D3DCAPS
typedef D3DCAPS9 D3DCapacity;

/// D3DSURFACE_DESC
typedef D3DSURFACE_DESC D3DSurfaceDescription;

/// D3DVIEWPORT9
typedef D3DVIEWPORT9 D3DViewport;

/// D3DLIGHT9
typedef D3DLIGHT9 D3DLight;

/// D3DMATERIAL9
typedef D3DMATERIAL9 D3DMaterial;

/// D3DVERTEXELEMENT9
typedef D3DVERTEXELEMENT9 D3DVertexElement;

//------------------------------------------------------------------------------
// o[Wio[֐̒`
//------------------------------------------------------------------------------

// DirectGraphics

/// Direct3DCreate
#define Direct3DCreate Direct3DCreate9

// DirectInput

/// DirectInputCreate
#define DirectInputCreate DirectInput8Create

//------------------------------------------------------------------------------
// o[Wio[萔̒`
//------------------------------------------------------------------------------

// DirectInput

/// DirectInputInterfaceID
#define DirectInputInterfaceID IID_IDirectInput8

/// DirectInputDeviceClass_GameController
#define DirectInputDeviceClass_GameController DI8DEVCLASS_GAMECTRL

// DirectSound

/// DirectSoundBufferInterfaceID
#define DirectSoundBufferInterfaceID IID_IDirectSoundBuffer8

/// DirectSoundNotifyInterfaceID
#define DirectSoundNotifyInterfaceID IID_IDirectSoundNotify8

/// DirectSound3DBufferInterfaceID
#define DirectSound3DBufferInterfaceID IID_IDirectSound3DBuffer8

/// DirectSound3DBufferInterfaceID
#define DirectSound3DListenerInterfaceID IID_IDirectSound3DListener8

//------------------------------------------------------------------------------
// DirectXCu̒ǉ
//------------------------------------------------------------------------------

// DirectXGUID
#pragma comment(lib, "dxguid.lib")

// DirectGraphics
#pragma comment(lib, "d3d9.lib")

// DirectXOtBbNXGNXeVCu̒ǉ
#ifdef _DEBUG
	#pragma comment(lib, "d3dx9d.lib")
#else
	#pragma comment(lib, "d3dx9.lib")
#endif

// DirectInput
#pragma comment(lib, "dinput8.lib")

// DirectSound
#pragma comment(lib, "dsound.lib")

//dxerr9.lib

//------------------------------------------------------------------------------
#endif // End of DIRECT_X_DEFINITION_H_
//------------------------------------------------------------------------------
