//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OxNgwb_
 * @author Junpee
 */

#ifndef VECTOR_3_H_
#define VECTOR_3_H_

#include <Core/System/Math.h>
#include <Core/Primitive/String.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * OxNg
 *
 * ̃NX͌pȂŉB
 */
class Vector3{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Xl
			float x;
			/// Yl
			float y;
			/// Zl
			float z;
		};

		/// z
		float array[3];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [xNg
	static const Vector3 zero;

	/// XPʃxNg
	static const Vector3 unitX;

	/// YPʃxNg
	static const Vector3 unitY;

	/// ZPʃxNg
	static const Vector3 unitZ;

	/// XP[PʃxNg
	static const Vector3 unitScale;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	inline Vector3(){}

	/**
	 * RXgN^
	 * @param sourceX X̏l
	 * @param sourceY Y̏l
	 * @param sourceZ Z̏l
	 */
	inline Vector3(float sourceX, float sourceY, float sourceZ) :
		x(sourceX), y(sourceY), z(sourceZ){
	}

	/**
	 * RXgN^
	 * @param source lz
	 */
	inline explicit Vector3(const float* const source) :
		x(source[0]), y(source[1]), z(source[2]){
	}

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceX X̐ݒl
	 * @param sourceY Y̐ݒl
	 * @param sourceZ Z̐ݒl
	 */
	inline void set(float sourceX, float sourceY, float sourceZ){
		x = sourceX;
		y = sourceY;
		z = sourceZ;
	}

	/**
	 * l̐ݒ
	 * @param source ݒlz
	 */
	inline void set(const float* const source){
		x = source[0];
		y = source[1];
		z = source[2];
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addVector ZxNg
	 * @return ZꂽxNg
	 */
	inline Vector3 operator +(const Vector3& addVector) const{
		return Vector3(
			x + addVector.x,
			y + addVector.y,
			z + addVector.z);
	}

	/**
	 * Z
	 * @param subVector ZxNg
	 * @return ZꂽxNg
	 */
	inline Vector3 operator -(const Vector3& subVector) const{
		return Vector3(
			x - subVector.x,
			y - subVector.y,
			z - subVector.z);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽxNg
	 */
	inline Vector3 operator *(float mulValue) const{
		return Vector3(x * mulValue, y * mulValue, z * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulVector ZxNg
	 * @return ZꂽxNg
	 */
	inline friend Vector3 operator *(float mulValue, const Vector3& mulVector){
		return Vector3(
			mulVector.x * mulValue,
			mulVector.y * mulValue,
			mulVector.z * mulValue);
	}

	/**
	 * +Zq
	 * @return xNg̃Rs[
	 */
	inline Vector3 operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]xNg
	 */
	inline Vector3 operator -() const{ return Vector3(-x, -y, -z); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addVector ZxNg
	 * @return ZꂽxNg
	 */
	inline Vector3& operator +=(const Vector3& addVector){
		x += addVector.x;
		y += addVector.y;
		z += addVector.z;
		return *this;
	}

	/**
	 * Z
	 * @param subVector ZxNg
	 * @return ZꂽxNg
	 */
	inline Vector3& operator -=(const Vector3& subVector){
		x -= subVector.x;
		y -= subVector.y;
		z -= subVector.z;
		return *this;
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽxNg
	 */
	inline Vector3& operator *=(float mulValue){
		x *= mulValue;
		y *= mulValue;
		z *= mulValue;
		return *this;
	}

	/**
	 * txNg
	 */
	inline Vector3& inverse(){
		x = -x;
		y = -y;
		z = -z;
		return *this;
	}

	/**
	 * Βl
	 * @return ΒlɂꂽxNg
	 */
	inline Vector3& abs(){
		x = Math::abs(x);
		y = Math::abs(y);
		z = Math::abs(z);
		return *this;
	}

	//--------------------------------------------------------------------------
	// xNgZ
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param dotVector ςƂxNg
	 * @return ϒl
	 */
	inline float dotProduct(const Vector3& dotVector) const{
		return x * dotVector.x + y * dotVector.y + z * dotVector.z;
	}

	/**
	 * O
	 * @param crossVector OςƂxNg
	 * @return OσxNg
	 */
	// e|̍쐬KvɂȂ̂őo[W͍쐬Ȃ
	inline Vector3 crossProduct(const Vector3& crossVector) const{
		return Vector3(
			y * crossVector.z - z * crossVector.y,
			z * crossVector.x - x * crossVector.z,
			x * crossVector.y - y * crossVector.x
		);
	}

	//--------------------------------------------------------------------------
	// ֘A
	//--------------------------------------------------------------------------
	/**
	 * xNg̎擾
	 * @return xNg
	 */
	inline float getLength() const{
		return Math::sqrt(x * x + y * y + z * z);
	}

	/**
	 * xNg̐ݒ
	 * @param length ݒ肷xNg
	 */
	inline Vector3& setLength(float length){
		float nowLength = getLength();
		// 0̏ꍇɂΏ̓AvP[VɂĈႤ̂Assert
		Assert(nowLength >= Math::epsilon);
		(*this) *= (length / nowLength);
		return *this;
	}

	/**
	 * xNg̓擾
	 * @return xNg̓
	 */
	inline float getSquaredLength() const{
		return (x * x + y * y + z * z);
	}

	/**
	 * K
	 * @return KꂽxNg
	 */
	inline Vector3& normalize(){
		float nowLength = getLength();
		// 0̏ꍇɂΏ̓AvP[VɂĈႤ̂Assert
		Assert(nowLength >= Math::epsilon);
		(*this) *= (1.f / nowLength);
		return *this;
	}

	/**
	 * [xNgǂ
	 * @return [xNgȂtrueԂ
	 */
	inline bool isZero() const{
		return ((Math::abs(x) <= Math::epsilon) &&
			(Math::abs(y) <= Math::epsilon) &&
			(Math::abs(z) <= Math::epsilon));
	}

	/**
	 * PʃxNgǂ
	 * @return PʃxNgȂtrueԂ
	 */
	inline bool isUnit() const{
		return (Math::abs(getLength() - 1.f) <= Math::epsilon);
	}

	/**
	 * ől
	 * @return ől
	 */
	inline float maximumValue() const{
		float result = x;
		if(y > result){ result = y; }
		if(z > result){ result = z; }
		return result;
	}

	/**
	 * ŏl
	 * @return ŏl
	 */
	inline float minimumValue() const{
		float result = x;
		if(y < result){ result = y; }
		if(z < result){ result = z; }
		return result;
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * xNgǂ
	 * @param target rxNg
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Vector3& target) const{
		return ((x == target.x) && (y == target.y) && (z == target.z));
	}

	/**
	 * xNgǂ
	 * @param target rxNg
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(const Vector3& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(x - target.x) <= epsilon) &&
			(Math::abs(y - target.y) <= epsilon) &&
			(Math::abs(z - target.z) <= epsilon));
	}

	/**
	 * xNgłȂǂ
	 * @param target rxNg
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const Vector3& target) const{
		return ((x != target.x) || (y != target.y) || (z != target.z));
	}

	/**
	 * xNgłȂǂ
	 * @param target rxNg
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(const Vector3& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(x - target.x) > epsilon) ||
			(Math::abs(y - target.y) > epsilon) ||
			(Math::abs(z - target.z) > epsilon));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return xNg̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f, %.8f, %.8f )", x, y, z);
		return returnString;
	}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VECTOR_3_H_
//------------------------------------------------------------------------------
