//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * leNX`Wwb_
 * @author Junpee
 */

#ifndef TEX_COORD_4_H_
#define TEX_COORD_4_H_

#include <Core/System/Math.h>
#include <Core/Primitive/String.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * leNX`W
 *
 * ̃NX͌pȂŉB
 */
class TexCoord4{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Ul
			float u;
			/// Vl
			float v;
			/// Wl
			float w;
			/// Xl
			float x;
		};

		/// z
		float array[4];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [W
	static const TexCoord4 zero;

	/// PʍW
	static const TexCoord4 unit;

	/// UPʍW
	static const TexCoord4 unitU;

	/// VPʍW
	static const TexCoord4 unitV;

	/// WPʍW
	static const TexCoord4 unitW;

	/// XPʍW
	static const TexCoord4 unitX;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	inline TexCoord4(){}

	/**
	 * RXgN^
	 * @param sourceU Ȕl
	 * @param sourceV V̏l
	 * @param sourceW W̏l
	 * @param sourceX X̏l
	 */
	inline TexCoord4(
		float sourceU, float sourceV, float sourceW, float sourceX) :
		u(sourceU), v(sourceV), w(sourceW), x(sourceX){
	}

	/**
	 * RXgN^
	 * @param source lz
	 */
	inline explicit TexCoord4(const float* const source) :
		u(source[0]), v(source[1]), w(source[2]), x(source[3]){
	}

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceU U̐ݒl
	 * @param sourceV V̐ݒl
	 * @param sourceW W̐ݒl
	 * @param sourceX X̐ݒl
	 */
	inline void set(float sourceU, float sourceV, float sourceW, float sourceX){
		u = sourceU;
		v = sourceV;
		w = sourceW;
		x = sourceX;
	}

	/**
	 * l̐ݒ
	 * @param source ݒlz
	 */
	inline void set(const float* const source){
		u = source[0];
		v = source[1];
		w = source[2];
		x = source[3];
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord ZleNX`W
	 * @return ZꂽleNX`W
	 */
	inline TexCoord4 operator +(const TexCoord4& addCoord) const{
		return TexCoord4(u + addCoord.u, v + addCoord.v,
			w + addCoord.w, x + addCoord.x);
	}

	/**
	 * Z
	 * @param subCoord ZleNX`W
	 * @return ZꂽleNX`W
	 */
	inline TexCoord4 operator -(const TexCoord4& subCoord) const{
		return TexCoord4(u - subCoord.u, v - subCoord.v,
			w - subCoord.w, x - subCoord.x);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽleNX`W
	 */
	inline TexCoord4 operator *(float mulValue) const{
		return TexCoord4(u * mulValue, v * mulValue,
			w * mulValue, x * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulCoord ZleNX`W
	 * @return ZꂽleNX`W
	 */
	inline friend TexCoord4 operator *(
		float mulValue, const TexCoord4& mulCoord){
		return TexCoord4(mulCoord.u * mulValue, mulCoord.v * mulValue,
			mulCoord.w * mulValue, mulCoord.x * mulValue);
	}

	/**
	 * +Zq
	 * @return leNX`W̃Rs[
	 */
	inline TexCoord4 operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]leNX`W
	 */
	inline TexCoord4 operator -() const{ return TexCoord4(-u, -v, -w, -x); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord ZleNX`W
	 * @return ZꂽleNX`W
	 */
	inline TexCoord4& operator +=(const TexCoord4& addCoord){
		u += addCoord.u;
		v += addCoord.v;
		w += addCoord.w;
		x += addCoord.x;
		return *this;
	}

	/**
	 * Z
	 * @param subCoord ZleNX`W
	 * @return ZꂽleNX`W
	 */
	inline TexCoord4& operator -=(const TexCoord4& subCoord){
		u -= subCoord.u;
		v -= subCoord.v;
		w -= subCoord.w;
		x -= subCoord.x;
		return *this;
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽleNX`W
	 */
	inline TexCoord4& operator *=(float mulValue){
		u *= mulValue;
		v *= mulValue;
		w *= mulValue;
		x *= mulValue;
		return *this;
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * leNX`Wǂ
	 * @param target rleNX`W
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const TexCoord4& target) const{
		return ((u == target.u) && (v == target.v) &&
			(w == target.w) && (x == target.x));
	}

	/**
	 * leNX`Wǂ
	 * @param target rleNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(
		const TexCoord4& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(u - target.u) <= epsilon) &&
			(Math::abs(v - target.v) <= epsilon) &&
			(Math::abs(w - target.w) <= epsilon) &&
			(Math::abs(x - target.x) <= epsilon));
	}

	/**
	 * leNX`WłȂǂ
	 * @param target rleNX`W
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const TexCoord4& target) const{
		return ((u != target.u) || (v != target.v) ||
			(w != target.w) || (x != target.x));
	}

	/**
	 * leNX`WłȂǂ
	 * @param target rleNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const TexCoord4& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(u - target.u) > epsilon) ||
			(Math::abs(v - target.v) > epsilon) ||
			(Math::abs(w - target.w) > epsilon) ||
			(Math::abs(x - target.x) > epsilon));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return leNX`W̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f, %.8f, %.8f, %.8f )", u, v, w, x);
		return returnString;
	}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEX_COORD_4_H_
//------------------------------------------------------------------------------
