//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OeNX`Wwb_
 * @author Junpee
 */

#ifndef TEX_COORD_3_H_
#define TEX_COORD_3_H_

#include <Core/System/Math.h>
#include <Core/Primitive/String.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * OeNX`W
 *
 * ̃NX͌pȂŉB
 */
class TexCoord3{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Ul
			float u;
			/// Vl
			float v;
			/// Wl
			float w;
		};

		/// z
		float array[3];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [W
	static const TexCoord3 zero;

	/// PʍW
	static const TexCoord3 unit;

	/// UPʍW
	static const TexCoord3 unitU;

	/// VPʍW
	static const TexCoord3 unitV;

	/// WPʍW
	static const TexCoord3 unitW;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	inline TexCoord3(){}

	/**
	 * RXgN^
	 * @param sourceU Ȕl
	 * @param sourceV V̏l
	 * @param sourceW W̏l
	 */
	inline TexCoord3(float sourceU, float sourceV, float sourceW) :
		u(sourceU), v(sourceV), w(sourceW){
	}

	/**
	 * RXgN^
	 * @param source lz
	 */
	inline explicit TexCoord3(const float* const source) :
		u(source[0]), v(source[1]), w(source[2]){
	}

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceU U̐ݒl
	 * @param sourceV V̐ݒl
	 * @param sourceW W̐ݒl
	 */
	inline void set(float sourceU, float sourceV, float sourceW){
		u = sourceU;
		v = sourceV;
		w = sourceW;
	}

	/**
	 * l̐ݒ
	 * @param source ݒlz
	 */
	inline void set(const float* const source){
		u = source[0];
		v = source[1];
		w = source[2];
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord ZOeNX`W
	 * @return ZꂽOeNX`W
	 */
	inline TexCoord3 operator +(const TexCoord3& addCoord) const{
		return TexCoord3(u + addCoord.u, v + addCoord.v, w + addCoord.w);
	}

	/**
	 * Z
	 * @param subCoord ZOeNX`W
	 * @return ZꂽOeNX`W
	 */
	inline TexCoord3 operator -(const TexCoord3& subCoord) const{
		return TexCoord3(u - subCoord.u, v - subCoord.v, w - subCoord.w);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽOeNX`W
	 */
	inline TexCoord3 operator *(float mulValue) const{
		return TexCoord3(u * mulValue, v * mulValue, w * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulCoord ZOeNX`W
	 * @return ZꂽOeNX`W
	 */
	inline friend TexCoord3 operator *(
		float mulValue, const TexCoord3& mulCoord){
		return TexCoord3(mulCoord.u * mulValue, mulCoord.v * mulValue,
			mulCoord.w * mulValue);
	}

	/**
	 * +Zq
	 * @return OeNX`W̃Rs[
	 */
	inline TexCoord3 operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]OeNX`W
	 */
	inline TexCoord3 operator -() const{ return TexCoord3(-u, -v, -w); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord ZOeNX`W
	 * @return ZꂽOeNX`W
	 */
	inline TexCoord3& operator +=(const TexCoord3& addCoord){
		u += addCoord.u;
		v += addCoord.v;
		w += addCoord.w;
		return *this;
	}

	/**
	 * Z
	 * @param subCoord ZOeNX`W
	 * @return ZꂽOeNX`W
	 */
	inline TexCoord3& operator -=(const TexCoord3& subCoord){
		u -= subCoord.u;
		v -= subCoord.v;
		w -= subCoord.w;
		return *this;
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽOeNX`W
	 */
	inline TexCoord3& operator *=(float mulValue){
		u *= mulValue;
		v *= mulValue;
		w *= mulValue;
		return *this;
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * OeNX`Wǂ
	 * @param target rOeNX`W
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const TexCoord3& target) const{
		return ((u == target.u) && (v == target.v) && (w == target.w));
	}

	/**
	 * OeNX`Wǂ
	 * @param target rOeNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(
		const TexCoord3& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(u - target.u) <= epsilon) &&
			(Math::abs(v - target.v) <= epsilon) &&
			(Math::abs(w - target.w) <= epsilon));
	}

	/**
	 * OeNX`WłȂǂ
	 * @param target rOeNX`W
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const TexCoord3& target) const{
		return ((u != target.u) || (v != target.v) || (w != target.w));
	}

	/**
	 * OeNX`WłȂǂ
	 * @param target rOeNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const TexCoord3& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(u - target.u) > epsilon) ||
			(Math::abs(v - target.v) > epsilon) ||
			(Math::abs(w - target.w) > epsilon));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return OeNX`W̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f, %.8f, %.8f )", u, v, w);
		return returnString;
	}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEX_COORD_3_H_
//------------------------------------------------------------------------------
