//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * 񎟌eNX`Wwb_
 * @author Junpee
 */

#ifndef TEX_COORD_2_H_
#define TEX_COORD_2_H_

#include <Core/System/Math.h>
#include <Core/Primitive/String.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * 񎟌eNX`W
 *
 * ̃NX͌pȂŉB
 */
class TexCoord2{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Ul
			float u;
			/// Vl
			float v;
		};

		/// z
		float array[2];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [W
	static const TexCoord2 zero;

	/// PʍW
	static const TexCoord2 unit;

	/// UPʍW
	static const TexCoord2 unitU;

	/// VPʍW
	static const TexCoord2 unitV;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	inline TexCoord2(){}

	/**
	 * RXgN^
	 * @param sourceU Ȕl
	 * @param sourceV V̏l
	 */
	inline TexCoord2(float sourceU, float sourceV) :
		u(sourceU), v(sourceV){
	}

	/**
	 * RXgN^
	 * @param source lz
	 */
	inline explicit TexCoord2(const float* const source) :
		u(source[0]), v(source[1]){
	}

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceU U̐ݒl
	 * @param sourceV V̐ݒl
	 */
	inline void set(float sourceU, float sourceV){
		u = sourceU;
		v = sourceV;
	}

	/**
	 * l̐ݒ
	 * @param source ݒlz
	 */
	inline void set(const float* const source){
		u = source[0];
		v = source[1];
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord Z񎟌eNX`W
	 * @return Zꂽ񎟌eNX`W
	 */
	inline TexCoord2 operator +(const TexCoord2& addCoord) const{
		return TexCoord2(u + addCoord.u, v + addCoord.v);
	}

	/**
	 * Z
	 * @param subCoord Z񎟌eNX`W
	 * @return Zꂽ񎟌eNX`W
	 */
	inline TexCoord2 operator -(const TexCoord2& subCoord) const{
		return TexCoord2(u - subCoord.u, v - subCoord.v);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ񎟌eNX`W
	 */
	inline TexCoord2 operator *(float mulValue) const{
		return TexCoord2(u * mulValue, v * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulCoord Z񎟌eNX`W
	 * @return Zꂽ񎟌eNX`W
	 */
	inline friend TexCoord2 operator *(
		float mulValue, const TexCoord2& mulCoord){
		return TexCoord2(mulCoord.u * mulValue, mulCoord.v * mulValue);
	}

	/**
	 * +Zq
	 * @return 񎟌eNX`W̃Rs[
	 */
	inline TexCoord2 operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]񎟌eNX`W
	 */
	inline TexCoord2 operator -() const{ return TexCoord2(-u, -v); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord Z񎟌eNX`W
	 * @return Zꂽ񎟌eNX`W
	 */
	inline TexCoord2& operator +=(const TexCoord2& addCoord){
		u += addCoord.u;
		v += addCoord.v;
		return *this;
	}

	/**
	 * Z
	 * @param subCoord Z񎟌eNX`W
	 * @return Zꂽ񎟌eNX`W
	 */
	inline TexCoord2& operator -=(const TexCoord2& subCoord){
		u -= subCoord.u;
		v -= subCoord.v;
		return *this;
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ񎟌eNX`W
	 */
	inline TexCoord2& operator *=(float mulValue){
		u *= mulValue;
		v *= mulValue;
		return *this;
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * 񎟌eNX`Wǂ
	 * @param target r񎟌eNX`W
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const TexCoord2& target) const{
		return ((u == target.u) && (v == target.v));
	}

	/**
	 * 񎟌eNX`Wǂ
	 * @param target r񎟌eNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(
		const TexCoord2& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(u - target.u) <= epsilon) &&
			(Math::abs(v - target.v) <= epsilon));
	}

	/**
	 * 񎟌eNX`WłȂǂ
	 * @param target r񎟌eNX`W
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const TexCoord2& target) const{
		return ((u != target.u) || (v != target.v));
	}

	/**
	 * 񎟌eNX`WłȂǂ
	 * @param target r񎟌eNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const TexCoord2& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(u - target.u) > epsilon) ||
			(Math::abs(v - target.v) > epsilon));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return 񎟌eNX`W̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f, %.8f )", u, v);
		return returnString;
	}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEX_COORD_2_H_
//------------------------------------------------------------------------------
