//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ꎟeNX`Wwb_
 * @author Junpee
 */

#ifndef TEX_COORD_1_H_
#define TEX_COORD_1_H_

#include <Core/System/Math.h>
#include <Core/Primitive/String.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ꎟeNX`W
 *
 * ̃NX͌pȂŉB
 */
class TexCoord1{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Ul
			float u;
		};

		/// z
		float array[1];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [W
	static const TexCoord1 zero;

	/// PʍW
	static const TexCoord1 unit;

	/// UPʍW
	static const TexCoord1 unitU;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	inline TexCoord1(){}

	/**
	 * RXgN^
	 * @param sourceU Ȕl
	 */
	inline TexCoord1(float sourceU) : u(sourceU){}

	/**
	 * RXgN^
	 * @param source lz
	 */
	inline explicit TexCoord1(const float* const source) : u(source[0]){}

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceU U̐ݒl
	 */
	inline void set(float sourceU){ u = sourceU; }

	/**
	 * l̐ݒ
	 * @param source ݒlz
	 */
	inline void set(const float* const source){ u = source[0]; }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord ZꎟeNX`W
	 * @return ZꂽꎟeNX`W
	 */
	inline TexCoord1 operator +(const TexCoord1& addCoord) const{
		return TexCoord1(u + addCoord.u);
	}

	/**
	 * Z
	 * @param subCoord ZꎟeNX`W
	 * @return ZꂽꎟeNX`W
	 */
	inline TexCoord1 operator -(const TexCoord1& subCoord) const{
		return TexCoord1(u - subCoord.u);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽꎟeNX`W
	 */
	inline TexCoord1 operator *(float mulValue) const{
		return TexCoord1(u * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulCoord ZꎟeNX`W
	 * @return ZꂽꎟeNX`W
	 */
	inline friend TexCoord1 operator *(
		float mulValue, const TexCoord1& mulCoord){
		return TexCoord1(mulCoord.u * mulValue);
	}

	/**
	 * +Zq
	 * @return ꎟeNX`W̃Rs[
	 */
	inline TexCoord1 operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]ꎟeNX`W
	 */
	inline TexCoord1 operator -() const{ return TexCoord1(-u); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addCoord ZꎟeNX`W
	 * @return ZꂽꎟeNX`W
	 */
	inline TexCoord1& operator +=(const TexCoord1& addCoord){
		u += addCoord.u;
		return *this;
	}

	/**
	 * Z
	 * @param subCoord ZꎟeNX`W
	 * @return ZꂽꎟeNX`W
	 */
	inline TexCoord1& operator -=(const TexCoord1& subCoord){
		u -= subCoord.u;
		return *this;
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽꎟeNX`W
	 */
	inline TexCoord1& operator *=(float mulValue){
		u *= mulValue;
		return *this;
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * ꎟeNX`Wǂ
	 * @param target rꎟeNX`W
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const TexCoord1& target) const{
		return (u == target.u);
	}

	/**
	 * ꎟeNX`Wǂ
	 * @param target rꎟeNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(
		const TexCoord1& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (Math::abs(u - target.u) <= epsilon);
	}

	/**
	 * ꎟeNX`WłȂǂ
	 * @param target rꎟeNX`W
	 * @return łȂlłtrueԂ
	 */
	inline bool operator !=(const TexCoord1& target) const{
		return (u != target.u);
	}

	/**
	 * ꎟeNX`WłȂǂ
	 * @param target rꎟeNX`W
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const TexCoord1& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (Math::abs(u - target.u) > epsilon);
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꎟeNX`W̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f )", u);
		return returnString;
	}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEX_COORD_1_H_
//------------------------------------------------------------------------------
