//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eNX`Wwb_
 * @author Junpee
 */

#ifndef TEX_COORD_H_
#define TEX_COORD_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * eNX`W
 */
class TexCoord{
public:
	/// őeNX`WZbg
	static const int maxSetCount = 8;

	/// eNX`W^Cv
	enum Type{
		typeNone = 0,
		type1 = 1,
		type2 = 2,
		type3 = 3,
		type4 = 4,
		typeMax,
	};

	/**
	 * eNX`W^Cv當ւ̕ϊ
	 * @param texCoordType eNX`W^Cv
	 * @return eNX`W^Cv
	 */
	static String texCoordTypeToString(Type texCoordType);

	/**
	 * 񂩂eNX`W^Cvւ̕ϊ
	 * @param texCoordTypeString eNX`W^Cv
	 * @return eNX`W^Cv
	 */
	static Type texCoordTypeFromString(const String& texCoordTypeString);


private:
	// RXgN^̉B
	TexCoord();

	// eNX`W^Cve[u
	static const String texCoordTypeStringTable[];

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEX_COORD_H_
//------------------------------------------------------------------------------
