//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * wb_
 * @author Junpee
 */

#ifndef STRING_H_
#define STRING_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * 
 *
 * ̃NX͌pȂŉB
 */
class String{
public:
	//--------------------------------------------------------------------------
	// ̍\zAj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	String();

	/**
	 * RXgN^
	 *
	 * ɂ鏉
	 * @param initString 
	 */
	String(const char* initString);

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	String(const String& copy);

	/**
	 * Zq
	 * @param copy 
	 */
	String& operator =(const String& copy);

	/**
	 * Zq
	 * @param copy 
	 */
	String& operator =(const char* copy);

	/**
	 * fXgN^
	 */
	~String();

	//--------------------------------------------------------------------------
	// ̏擾
	//--------------------------------------------------------------------------
	/**
	 * ̃oCgԂ
	 *
	 * NULLI[܂܂Ȃ̃oCgԂ܂B
	 * @return ̃oCg
	 */
	// ƍȂ悤ɂׂlengthł͖sizeɂB
	int getSize() const{ return size_; }

	/**
	 * Ԃ
	 * @return Ɋ܂܂镶̐
	 */
	// gppxႭAph߂lengthł͖CharacterCountɂB
	int getCharacterCount() const;

	/**
	 * 󕶎񂩂ǂ
	 * @return 󕶎ȂtrueԂB
	 */
	bool isEmpty() const{ return (size_ == 0); }

	/**
	 * oCgV[PX̎擾
	 *
	 * 擾oCgV[PX͕ɕύXꂽ
	 * \܂B
	 * 擾|C^̃f[^𒼐ڏString삵܂B
	 * @return oCgV[PX
	 */
	const char* getBytes() const{
		if(string_ != NULL){ return string_; }
		return &nullString;
	}

	/**
	 * ̎擾
	 * @param index 擾镶̃CfbNX
	 * @return CfbNXʒuɂ镶
	 */
	char charAt(int index) const{
		Assert(index >= 0);
		Assert(index <= size_);
		if(string_ != NULL){ return string_[index]; }
		return nullString;
	}

	/**
	 * ̎擾
	 * @param beginIndex ̊Jnʒu
	 */
	String getSubstring(int beginIndex) const;

	/**
	 * ̎擾
	 * @param beginIndex ̊Jnʒu
	 * @param endIndex ̏Iʒu(ĨCfbNX + 1)
	 */
	String getSubstring(int beginIndex, int endIndex) const;

	/**
	 * 啶̎擾
	 * @return 啶
	 */
	String getUpperCase() const;

	/**
	 * ̎擾
	 * @return 
	 */
	String getLowerCase() const;

	/**
	 * nbVR[h̎擾
	 * @return nbVR[h
	 */
	u_int getHashCode() const;

	//--------------------------------------------------------------------------
	// p[X
	//--------------------------------------------------------------------------
	/**
	 * charւ̃p[X
	 * @param value [out] charꂽl܂
	 * @return trueȂp[X
	 */
	bool parseChar(char* value) const;

	/**
	 * u_charւ̃p[X
	 * @param value [out] u_charꂽl܂
	 * @return trueȂp[X
	 */
	bool parseUChar(u_char* value) const;

	/**
	 * shortւ̃p[X
	 * @param value [out] shortꂽl܂
	 * @return trueȂp[X
	 */
	bool parseShort(short* value) const;

	/**
	 * u_shortւ̃p[X
	 * @param value [out] u_shortꂽl܂
	 * @return trueȂp[X
	 */
	bool parseUShort(u_short* value) const;

	/**
	 * intւ̃p[X
	 * @param value [out] intꂽl܂
	 * @return trueȂp[X
	 */
	bool parseInt(int* value) const;

	/**
	 * u_intւ̃p[X
	 * @param value [out] u_intꂽl܂
	 * @return trueȂp[X
	 */
	bool parseUInt(u_int* value) const;

	/**
	 * floatւ̃p[X
	 * @param value [out] floatꂽl܂
	 * @return trueȂp[X
	 */
	bool parseFloat(float* value) const;

	/**
	 * doubleւ̃p[X
	 * @param value [out] doubleꂽl܂
	 * @return trueȂp[X
	 */
	bool parseDouble(double* value) const;

	//--------------------------------------------------------------------------
	// ύX
	//--------------------------------------------------------------------------
	/**
	 * ̒ǉ
	 * @param appendString A镶
	 * @return ύXςݕ
	 */
	String& append(const String& appendString);

	/**
	 * ̒ǉ
	 * @param appendString A镶
	 * @return ύXςݕ
	 */
	String& append(const char* appendString);

	/**
	 * ǉZq
	 * @param appendString ǉ
	 * @return ύXςݕ
	 */
	String& operator +=(const String& appendString){
		return append(appendString);
	}

	/**
	 * ǉZq
	 * @param appendString ǉ
	 * @return ύXςݕ
	 */
	String& operator +=(const char* appendString){
		return append(appendString);
	}

	/**
	 * tH[}bg
	 *
	 * printfƓŃtH[}bgݒ肷B
	 * %sStringꍇgetBytes()Kv
	 * @param formatString tH[}bg
	 * @param ... ϒ
	 * @return ύXςݕ
	 */
	String& format(const char* formatString, ...);

	//--------------------------------------------------------------------------
	// r
	//--------------------------------------------------------------------------
	/**
	 * ̎r
	 * @param compareString r镶
	 */
	int compareTo(const String& compareString) const;

	/**
	 * ̎r
	 * @param compareString r镶
	 */
	int compareTo(const char* compareString) const;

	/**
	 * 啶A𖳎̎r
	 * @param compareString r镶
	 */
	int compareToIgnoreCase(const String& compareString) const;

	/**
	 * ̔r
	 * @param compareString r镶
	 * @return 񂪓łtrue
	 */
	bool equals(const String& compareString) const;

	/**
	 * ̔r
	 * @param compareString r镶
	 * @return 񂪓łtrue
	 */
	bool equals(const char* compareString) const;

	/**
	 * ̔r
	 * @param compareString r镶
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const String& compareString) const{
		return equals(compareString);
	}

	/**
	 * ̔r
	 * @param compareString r镶
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const String& compareString) const{
		return !equals(compareString);
	}

	/**
	 * 啶A𖳎̔r
	 * @param compareString r镶
	 * @return 񂪓łtrue
	 */
	bool equalsIsIgnoreCase(const String& compareString) const;

	/**
	 * w肵Ŏn܂邩ǂ
	 * @param prefix r镶
	 * @return w肵Ŏn܂Ătrue
	 */
	bool startsWith(const String& prefix) const;

	/**
	 * w肵Ŏn܂邩ǂ
	 * @param prefix r镶
	 * @return w肵Ŏn܂Ătrue
	 */
	bool startsWith(const char* prefix) const;

	/**
	 * w肵ŏI邩ǂ
	 * @param suffix r镶
	 * @return w肵ŏIĂtrue
	 */
	bool endsWith(const String& suffix) const;

	/**
	 * w肵ŏI邩ǂ
	 * @param suffix r镶
	 * @return w肵ŏIĂtrue
	 */
	bool endsWith(const char* suffix) const;

	/**
	 * w肳ꂽŏɏoʒũCfbNX擾
	 * @param searchChar 
	 * @return ŏɏoʒũCfbNXB-1ԂB
	 */
	int getIndexOf(const char searchChar) const;

	/**
	 * w肳ꂽ񂪍ŏɏoʒũCfbNX擾
	 * @param searchString 
	 * @return ŏɏoʒũCfbNXB-1ԂB
	 */
	int getIndexOf(const char* searchString) const;

	/**
	 * w肳ꂽ񂪍ŏɏoʒũCfbNX擾
	 * @param searchString 
	 * @return ŏɏoʒũCfbNXB-1ԂB
	 */
	int getIndexOf(const String& searchString) const;

	/**
	 * w肳ꂽŌɏoʒũCfbNX擾
	 * @param searchChar 
	 * @return ŌɏoʒũCfbNXB-1ԂB
	 */
	int getLastIndexOf(const char searchChar) const;

	/**
	 * w肳ꂽ񂪍ŌɏoʒũCfbNX擾
	 * @param searchString 
	 * @return ŌɏoʒũCfbNXB-1ԂB
	 */
	int getLastIndexOf(const char* searchString) const;

	/**
	 * w肳ꂽ񂪍ŌɏoʒũCfbNX擾
	 * @param searchString 
	 * @return ŌɏoʒũCfbNXB-1ԂB
	 */
	int getLastIndexOf(const String& searchString) const;

#ifdef _DEBUG
	/**
	 * fobOpo
	 */
	void debugPrint();

#endif// End of _DEBUG

private:
	/**
	 * gpRXgN^
	 *
	 * ƒɂ鏉B󕶎nĂ͂ȂB
	 * t@XJE^CNgĂKvB
	 * @param initString 
	 * @param initLength 
	 */
	String(char* initString, int initLength);

	// 
	char* string_;
	// TCY
	int size_;
	// k
	static const char nullString = '\0';
	// tH[}bgftHg
	static const int formatDefaultLength = 64;
	// tH[}bgXP[
	static const int formatScale = 2;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
/**
 * ̘A
 * @param leftString Zq̍̕
 * @param rightString Zq̉E̕
 * @return Aꂽ
 */
const Lamp::String operator+(
	const Lamp::String& leftString, const Lamp::String& rightString);

//------------------------------------------------------------------------------
#endif // End of STRING_H_
//------------------------------------------------------------------------------
