//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `wb_
 * @author Junpee
 */

#ifndef RECTANGLE_I_H_
#define RECTANGLE_I_H_

namespace Lamp{

class RectangleF;

//------------------------------------------------------------------------------
/**
 * `
 *
 * ̃NX͌pȂŉB
 */
class RectangleI{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Xl
			int x;
			/// Yl
			int y;
			/// 
			int width;
			/// 
			int height;
		};

		/// z
		int array[4];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [`
	static const RectangleI zero;

	/// Pʋ`
	static const RectangleI unit;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	RectangleI(){}

	/**
	 * RXgN^
	 * @param sourceX Xl̏l
	 * @param sourceY Yl̏l
	 * @param sourceWidth ̏l
	 * @param sourceHeight ̏l
	 */
	RectangleI(int sourceX, int sourceY, int sourceWidth, int sourceHeight) :
		x(sourceX), y(sourceY), width(sourceWidth), height(sourceHeight){}

	/**
	 * RXgN^
	 * @param sourceArray lz
	 */
	explicit RectangleI(int sourceArray[4]) :
		x(sourceArray[0]), y(sourceArray[1]),
		width(sourceArray[2]), height(sourceArray[3]){}

	/**
	 * RXgN^
	 * @param source ݒ肷`
	 */
	explicit RectangleI(const RectangleF& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceX Xl̐ݒl
	 * @param sourceY Yl̐ݒl
	 * @param sourceWidth ̐ݒl
	 * @param sourceHeight ̐ݒl
	 */
	inline void set(int sourceX, int sourceY, int sourceWidth, int sourceHeight){
		x = sourceX;
		y = sourceY;
		width = sourceWidth;
		height = sourceHeight;
	}

	/**
	 * l̐ݒ
	 * @param sourceArray ݒlz
	 */
	inline void set(int sourceArray[4]){
		x = sourceArray[0];
		y = sourceArray[1];
		width = sourceArray[2];
		height = sourceArray[3];
	}

	/**
	 * l̐ݒ
	 * @param source ݒ肷`
	 */
	void set(const RectangleF& source);

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target r`
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const RectangleI& target) const{
		return ((x == target.x) && (y == target.y) &&
			(width == target.width) && (height == target.height));
	}

	/**
	 * lłȂǂ
	 * @param target r`
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const RectangleI& target) const{
		return ((x != target.x) || (y != target.y) ||
			(width != target.width) || (height != target.height));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return `̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %d, %d, %d, %d )", x, y, width, height);
		return returnString;
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RECTANGLE_I_H_
//------------------------------------------------------------------------------
