//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `wb_
 * @author Junpee
 */

#ifndef RECTANGLE_F_H_
#define RECTANGLE_F_H_

namespace Lamp{

class RectangleI;

//------------------------------------------------------------------------------
/**
 * `
 *
 * ̃NX͌pȂŉB
 */
class RectangleF{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Xl
			float x;
			/// Yl
			float y;
			/// 
			float width;
			/// 
			float height;
		};

		/// z
		float array[4];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [`
	static const RectangleF zero;

	/// Pʋ`
	static const RectangleF unit;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	RectangleF(){}

	/**
	 * RXgN^
	 * @param sourceX Xl̏l
	 * @param sourceY Yl̏l
	 * @param sourceWidth ̏l
	 * @param sourceHeight ̏l
	 */
	RectangleF(float sourceX, float sourceY,
		float sourceWidth, float sourceHeight) :
		x(sourceX), y(sourceY), width(sourceWidth), height(sourceHeight){}

	/**
	 * RXgN^
	 * @param sourceArray lz
	 */
	explicit RectangleF(float sourceArray[4]) :
		x(sourceArray[0]), y(sourceArray[1]),
		width(sourceArray[2]), height(sourceArray[3]){}

	/**
	 * RXgN^
	 * @param source ݒ肷`
	 */
	explicit RectangleF(const RectangleI& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceX Xl̐ݒl
	 * @param sourceY Yl̐ݒl
	 * @param sourceWidth ̐ݒl
	 * @param sourceHeight ̐ݒl
	 */
	inline void set(float sourceX, float sourceY,
		float sourceWidth, float sourceHeight){
		x = sourceX;
		y = sourceY;
		width = sourceWidth;
		height = sourceHeight;
	}

	/**
	 * l̐ݒ
	 * @param sourceArray ݒlz
	 */
	inline void set(float sourceArray[4]){
		x = sourceArray[0];
		y = sourceArray[1];
		width = sourceArray[2];
		height = sourceArray[3];
	}

	/**
	 * l̐ݒ
	 * @param source ݒ肷`
	 */
	void set(const RectangleI& source);

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target r`
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const RectangleF& target) const{
		return ((x == target.x) && (y == target.y) &&
			(width == target.width) && (height == target.height));
	}

	/**
	 * lǂ
	 * @param target r`
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(const RectangleF& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(x - target.x) <= epsilon) &&
			(Math::abs(y - target.y) <= epsilon) &&
			(Math::abs(width - target.width) <= epsilon) &&
			(Math::abs(height - target.height) <= epsilon));
	}

	/**
	 * lłȂǂ
	 * @param target r`
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const RectangleF& target) const{
		return ((x != target.x) || (y != target.y) ||
			(width != target.width) || (height != target.height));
	}

	/**
	 * lłȂǂ
	 * @param target r`
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const RectangleF& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(x - target.x) > epsilon) ||
			(Math::abs(y - target.y) > epsilon) ||
			(Math::abs(width - target.width) > epsilon) ||
			(Math::abs(height - target.height) > epsilon));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return `̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f, %.8f, %.8f, %.8f )", x, y, width, height);
		return returnString;
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of RECTANGLE_F_H_
//------------------------------------------------------------------------------
